/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.MeasurementGroup;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class InternalCreateMultiTimeSeriesNode
extends WritePlanNode {
    private Map<PartialPath, Pair<Boolean, MeasurementGroup>> deviceMap;
    private TRegionReplicaSet regionReplicaSet;

    public InternalCreateMultiTimeSeriesNode(PlanNodeId id, Map<PartialPath, Pair<Boolean, MeasurementGroup>> deviceMap) {
        super(id);
        this.deviceMap = deviceMap;
    }

    private InternalCreateMultiTimeSeriesNode(PlanNodeId id, Map<PartialPath, Pair<Boolean, MeasurementGroup>> deviceMap, TRegionReplicaSet regionReplicaSet) {
        super(id);
        this.deviceMap = deviceMap;
        this.regionReplicaSet = regionReplicaSet;
    }

    public Map<PartialPath, Pair<Boolean, MeasurementGroup>> getDeviceMap() {
        return this.deviceMap;
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    @Override
    public List<PlanNode> getChildren() {
        return new ArrayList<PlanNode>();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.INTERNAL_CREATE_MULTI_TIMESERIES;
    }

    @Override
    public PlanNode clone() {
        return new InternalCreateMultiTimeSeriesNode(this.getPlanNodeId(), this.deviceMap, this.regionReplicaSet);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.INTERNAL_CREATE_MULTI_TIMESERIES.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.deviceMap.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry<PartialPath, Pair<Boolean, MeasurementGroup>> entry : this.deviceMap.entrySet()) {
            entry.getKey().serialize(byteBuffer);
            ReadWriteIOUtils.write((Boolean)((Boolean)entry.getValue().left), (ByteBuffer)byteBuffer);
            ((MeasurementGroup)entry.getValue().right).serialize(byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.INTERNAL_CREATE_MULTI_TIMESERIES.serialize(stream);
        ReadWriteIOUtils.write((int)this.deviceMap.size(), (OutputStream)stream);
        for (Map.Entry<PartialPath, Pair<Boolean, MeasurementGroup>> entry : this.deviceMap.entrySet()) {
            entry.getKey().serialize((OutputStream)stream);
            ReadWriteIOUtils.write((Boolean)((Boolean)entry.getValue().left), (OutputStream)stream);
            ((MeasurementGroup)entry.getValue().right).serialize(stream);
        }
    }

    public static InternalCreateMultiTimeSeriesNode deserialize(ByteBuffer byteBuffer) {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        HashMap<PartialPath, Pair<Boolean, MeasurementGroup>> deviceMap = new HashMap<PartialPath, Pair<Boolean, MeasurementGroup>>(size);
        for (int i = 0; i < size; ++i) {
            PartialPath devicePath = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
            boolean isAligned = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
            MeasurementGroup measurementGroup = new MeasurementGroup();
            measurementGroup.deserialize(byteBuffer);
            deviceMap.put(devicePath, (Pair<Boolean, MeasurementGroup>)new Pair((Object)isAligned, (Object)measurementGroup));
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new InternalCreateMultiTimeSeriesNode(planNodeId, deviceMap);
    }

    @Override
    public List<WritePlanNode> splitByPartition(IAnalysis analysis) {
        HashMap<TRegionReplicaSet, Map> splitMap = new HashMap<TRegionReplicaSet, Map>();
        for (Map.Entry<PartialPath, Pair<Boolean, MeasurementGroup>> entry : this.deviceMap.entrySet()) {
            TRegionReplicaSet regionReplicaSet = analysis.getSchemaPartitionInfo().getSchemaRegionReplicaSet(entry.getKey().getIDeviceIDAsFullDevice());
            splitMap.computeIfAbsent(regionReplicaSet, k -> new HashMap()).put(entry.getKey(), entry.getValue());
        }
        ArrayList<WritePlanNode> result = new ArrayList<WritePlanNode>();
        for (Map.Entry entry : splitMap.entrySet()) {
            result.add(new InternalCreateMultiTimeSeriesNode(this.getPlanNodeId(), (Map)entry.getValue(), (TRegionReplicaSet)entry.getKey()));
        }
        return result;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitInternalCreateMultiTimeSeries(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InternalCreateMultiTimeSeriesNode that = (InternalCreateMultiTimeSeriesNode)o;
        return Objects.equals(this.deviceMap, that.deviceMap) && Objects.equals(this.regionReplicaSet, that.regionReplicaSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.deviceMap, this.regionReplicaSet);
    }
}

