/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.parser;

import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.sql.IoTDBSqlParser;
import org.apache.iotdb.db.qp.sql.SqlLexer;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeDevicePathCache;
import org.apache.iotdb.db.queryengine.plan.expression.binary.GreaterEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LessThanExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.parser.ASTVisitor;
import org.apache.iotdb.db.queryengine.plan.parser.SqlParseError;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.component.FromComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByTimeComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.ResultColumn;
import org.apache.iotdb.db.queryengine.plan.statement.component.SelectComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.WhereCondition;
import org.apache.iotdb.db.queryengine.plan.statement.crud.DeleteDataStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsOfOneDeviceStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateAlignedTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DatabaseSchemaStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DeleteDatabaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DeleteTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.BatchActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.CreateSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.DropSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.SetSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowNodesInSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowPathSetTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowPathsUsingTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.UnsetSchemaTemplateStatement;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.MetaFormatUtils;
import org.apache.iotdb.db.schemaengine.template.TemplateQueryType;
import org.apache.iotdb.db.utils.QueryDataSetUtils;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.iotdb.db.utils.constant.SqlConstant;
import org.apache.iotdb.mpp.rpc.thrift.TFetchTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSAggregationQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateAlignedTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateMultiTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSDeleteDataReq;
import org.apache.iotdb.service.rpc.thrift.TSDropSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletsReq;
import org.apache.iotdb.service.rpc.thrift.TSLastDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSQueryTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSRawDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSSetSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSUnsetSchemaTemplateReq;
import org.apache.tsfile.enums.ColumnCategory;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.utils.TimeDuration;

public class StatementGenerator {
    private static final PerformanceOverviewMetrics PERFORMANCE_OVERVIEW_METRICS = PerformanceOverviewMetrics.getInstance();
    private static final DataNodeDevicePathCache DEVICE_PATH_CACHE = DataNodeDevicePathCache.getInstance();

    private StatementGenerator() {
    }

    public static Statement createStatement(String sql, ZoneId zoneId) {
        return StatementGenerator.invokeParser(sql, zoneId);
    }

    public static Statement createStatement(TSRawDataQueryReq rawDataQueryReq) throws IllegalPathException {
        long startTime = System.nanoTime();
        SelectComponent selectComponent = new SelectComponent();
        FromComponent fromComponent = new FromComponent();
        WhereCondition whereCondition = new WhereCondition();
        for (String pathStr : rawDataQueryReq.getPaths()) {
            PartialPath path = rawDataQueryReq.isLegalPathNodes() ? new PartialPath(pathStr.split("\\.")) : new PartialPath(pathStr);
            fromComponent.addPrefixPath(path);
        }
        selectComponent.addResultColumn(new ResultColumn(new TimeSeriesOperand(new PartialPath("", false)), ResultColumn.ColumnType.RAW));
        GreaterEqualExpression leftPredicate = new GreaterEqualExpression(new TimestampOperand(), new ConstantOperand(TSDataType.INT64, Long.toString(rawDataQueryReq.getStartTime())));
        LessThanExpression rightPredicate = new LessThanExpression(new TimestampOperand(), new ConstantOperand(TSDataType.INT64, Long.toString(rawDataQueryReq.getEndTime())));
        LogicAndExpression predicate = new LogicAndExpression(leftPredicate, rightPredicate);
        whereCondition.setPredicate(predicate);
        QueryStatement queryStatement = new QueryStatement();
        queryStatement.setSelectComponent(selectComponent);
        queryStatement.setFromComponent(fromComponent);
        queryStatement.setWhereCondition(whereCondition);
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return queryStatement;
    }

    public static Statement createStatement(TSLastDataQueryReq lastDataQueryReq) throws IllegalPathException {
        long startTime = System.nanoTime();
        SelectComponent selectComponent = new SelectComponent();
        FromComponent fromComponent = new FromComponent();
        selectComponent.setHasLast(true);
        for (String pathStr : lastDataQueryReq.getPaths()) {
            PartialPath path = lastDataQueryReq.isLegalPathNodes() ? new PartialPath(pathStr.split("\\.")) : new PartialPath(pathStr);
            fromComponent.addPrefixPath(path);
        }
        selectComponent.addResultColumn(new ResultColumn(new TimeSeriesOperand(new PartialPath("", false)), ResultColumn.ColumnType.RAW));
        QueryStatement lastQueryStatement = new QueryStatement();
        if (lastDataQueryReq.getTime() != Long.MIN_VALUE) {
            WhereCondition whereCondition = new WhereCondition();
            GreaterEqualExpression predicate = new GreaterEqualExpression(new TimestampOperand(), new ConstantOperand(TSDataType.INT64, Long.toString(lastDataQueryReq.getTime())));
            whereCondition.setPredicate(predicate);
            lastQueryStatement.setWhereCondition(whereCondition);
        }
        lastQueryStatement.setSelectComponent(selectComponent);
        lastQueryStatement.setFromComponent(fromComponent);
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return lastQueryStatement;
    }

    public static Statement createStatement(TSAggregationQueryReq req) throws IllegalPathException {
        long startTime = System.nanoTime();
        QueryStatement queryStatement = new QueryStatement();
        FromComponent fromComponent = new FromComponent();
        fromComponent.addPrefixPath(new PartialPath("", false));
        queryStatement.setFromComponent(fromComponent);
        SelectComponent selectComponent = new SelectComponent();
        ArrayList<PartialPath> selectPaths = new ArrayList<PartialPath>();
        for (String pathStr : req.getPaths()) {
            if (req.isLegalPathNodes()) {
                selectPaths.add(new PartialPath(pathStr.split("\\.")));
                continue;
            }
            selectPaths.add(new PartialPath(pathStr));
        }
        List aggregations = req.getAggregations();
        for (int i = 0; i < aggregations.size(); ++i) {
            selectComponent.addResultColumn(new ResultColumn(new FunctionExpression(((TAggregationType)aggregations.get(i)).toString(), new LinkedHashMap<String, String>(), Collections.singletonList(new TimeSeriesOperand((PartialPath)selectPaths.get(i)))), ResultColumn.ColumnType.AGGREGATION));
        }
        queryStatement.setSelectComponent(selectComponent);
        if (req.isSetInterval()) {
            GroupByTimeComponent groupByTimeComponent = new GroupByTimeComponent();
            groupByTimeComponent.setStartTime(req.getStartTime());
            groupByTimeComponent.setEndTime(req.getEndTime());
            groupByTimeComponent.setInterval(new TimeDuration(0, req.getInterval()));
            if (req.isSetSlidingStep()) {
                groupByTimeComponent.setSlidingStep(new TimeDuration(0, req.getSlidingStep()));
            } else {
                groupByTimeComponent.setSlidingStep(groupByTimeComponent.getInterval());
            }
            queryStatement.setGroupByTimeComponent(groupByTimeComponent);
        } else if (req.isSetStartTime()) {
            WhereCondition whereCondition = new WhereCondition();
            GreaterEqualExpression leftPredicate = new GreaterEqualExpression(new TimestampOperand(), new ConstantOperand(TSDataType.INT64, Long.toString(req.getStartTime())));
            LessThanExpression rightPredicate = new LessThanExpression(new TimestampOperand(), new ConstantOperand(TSDataType.INT64, Long.toString(req.getEndTime())));
            LogicAndExpression predicate = new LogicAndExpression(leftPredicate, rightPredicate);
            whereCondition.setPredicate(predicate);
            queryStatement.setWhereCondition(whereCondition);
        }
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return queryStatement;
    }

    public static InsertRowStatement createStatement(TSInsertRecordReq insertRecordReq) throws IllegalPathException, QueryProcessException {
        long startTime = System.nanoTime();
        InsertRowStatement insertStatement = new InsertRowStatement();
        insertStatement.setDevicePath(DEVICE_PATH_CACHE.getPartialPath(insertRecordReq.getPrefixPath()));
        TimestampPrecisionUtils.checkTimestampPrecision(insertRecordReq.getTimestamp());
        insertStatement.setTime(insertRecordReq.getTimestamp());
        insertStatement.setMeasurements(insertRecordReq.getMeasurements().toArray(new String[0]));
        insertStatement.setAligned(insertRecordReq.isAligned);
        insertStatement.fillValues(insertRecordReq.values);
        if (insertRecordReq.isSetIsWriteToTable()) {
            insertStatement.setWriteToTable(insertRecordReq.isIsWriteToTable());
            if (!insertRecordReq.isSetColumnCategoryies() || insertRecordReq.getColumnCategoryiesSize() != insertRecordReq.getMeasurementsSize()) {
                throw new IllegalArgumentException("Missing or invalid column categories for table insertion");
            }
            TsTableColumnCategory[] columnCategories = new TsTableColumnCategory[insertRecordReq.getColumnCategoryies().size()];
            for (int i = 0; i < columnCategories.length; ++i) {
                columnCategories[i] = TsTableColumnCategory.fromTsFileColumnCategory((ColumnCategory)ColumnCategory.values()[((Byte)insertRecordReq.getColumnCategoryies().get(i)).intValue()]);
            }
            insertStatement.setColumnCategories(columnCategories);
        }
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return insertStatement;
    }

    public static InsertRowStatement createStatement(TSInsertStringRecordReq insertRecordReq) throws IllegalPathException {
        long startTime = System.nanoTime();
        InsertRowStatement insertStatement = new InsertRowStatement();
        insertStatement.setDevicePath(DEVICE_PATH_CACHE.getPartialPath(insertRecordReq.getPrefixPath()));
        TimestampPrecisionUtils.checkTimestampPrecision(insertRecordReq.getTimestamp());
        insertStatement.setTime(insertRecordReq.getTimestamp());
        insertStatement.setMeasurements(insertRecordReq.getMeasurements().toArray(new String[0]));
        insertStatement.setDataTypes(new TSDataType[insertStatement.getMeasurements().length]);
        insertStatement.setValues(insertRecordReq.getValues().toArray(new Object[0]));
        insertStatement.setNeedInferType(true);
        insertStatement.setAligned(insertRecordReq.isAligned);
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return insertStatement;
    }

    public static InsertTabletStatement createStatement(TSInsertTabletReq insertTabletReq) throws IllegalPathException {
        long startTime = System.nanoTime();
        InsertTabletStatement insertStatement = new InsertTabletStatement();
        insertStatement.setDevicePath(DEVICE_PATH_CACHE.getPartialPath(insertTabletReq.getPrefixPath()));
        insertStatement.setMeasurements(insertTabletReq.getMeasurements().toArray(new String[0]));
        long[] timestamps = QueryDataSetUtils.readTimesFromBuffer(insertTabletReq.timestamps, insertTabletReq.size);
        if (timestamps.length != 0) {
            TimestampPrecisionUtils.checkTimestampPrecision(timestamps[timestamps.length - 1]);
        }
        insertStatement.setTimes(timestamps);
        insertStatement.setColumns(QueryDataSetUtils.readTabletValuesFromBuffer(insertTabletReq.values, insertTabletReq.types, insertTabletReq.types.size(), insertTabletReq.size));
        insertStatement.setBitMaps(QueryDataSetUtils.readBitMapsFromBuffer(insertTabletReq.values, insertTabletReq.types.size(), insertTabletReq.size).orElse(null));
        insertStatement.setRowCount(insertTabletReq.size);
        TSDataType[] dataTypes = new TSDataType[insertTabletReq.types.size()];
        for (int i = 0; i < insertTabletReq.types.size(); ++i) {
            dataTypes[i] = TSDataType.deserialize((byte)((byte)((Integer)insertTabletReq.types.get(i)).intValue()));
        }
        insertStatement.setDataTypes(dataTypes);
        insertStatement.setAligned(insertTabletReq.isAligned);
        insertStatement.setWriteToTable(insertTabletReq.isWriteToTable());
        if (insertTabletReq.isWriteToTable()) {
            if (!insertTabletReq.isSetColumnCategories() || insertTabletReq.getColumnCategoriesSize() != insertTabletReq.getMeasurementsSize()) {
                throw new IllegalArgumentException("Missing or invalid column categories for table insertion");
            }
            TsTableColumnCategory[] columnCategories = new TsTableColumnCategory[insertTabletReq.columnCategories.size()];
            for (int i = 0; i < columnCategories.length; ++i) {
                columnCategories[i] = TsTableColumnCategory.fromTsFileColumnCategory((ColumnCategory)ColumnCategory.values()[((Byte)insertTabletReq.columnCategories.get(i)).intValue()]);
            }
            insertStatement.setColumnCategories(columnCategories);
        }
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return insertStatement;
    }

    public static InsertMultiTabletsStatement createStatement(TSInsertTabletsReq req) throws IllegalPathException {
        long startTime = System.nanoTime();
        InsertMultiTabletsStatement insertStatement = new InsertMultiTabletsStatement();
        ArrayList<InsertTabletStatement> insertTabletStatementList = new ArrayList<InsertTabletStatement>();
        for (int i = 0; i < req.prefixPaths.size(); ++i) {
            InsertTabletStatement insertTabletStatement = new InsertTabletStatement();
            insertTabletStatement.setDevicePath(DEVICE_PATH_CACHE.getPartialPath((String)req.prefixPaths.get(i)));
            insertTabletStatement.setMeasurements(((List)req.measurementsList.get(i)).toArray(new String[0]));
            long[] timestamps = QueryDataSetUtils.readTimesFromBuffer((ByteBuffer)req.timestampsList.get(i), (Integer)req.sizeList.get(i));
            if (timestamps.length != 0) {
                TimestampPrecisionUtils.checkTimestampPrecision(timestamps[timestamps.length - 1]);
            }
            insertTabletStatement.setTimes(timestamps);
            insertTabletStatement.setColumns(QueryDataSetUtils.readTabletValuesFromBuffer((ByteBuffer)req.valuesList.get(i), (List)req.typesList.get(i), ((List)req.measurementsList.get(i)).size(), (int)((Integer)req.sizeList.get(i))));
            insertTabletStatement.setBitMaps(QueryDataSetUtils.readBitMapsFromBuffer((ByteBuffer)req.valuesList.get(i), ((List)req.measurementsList.get(i)).size(), (Integer)req.sizeList.get(i)).orElse(null));
            insertTabletStatement.setRowCount((Integer)req.sizeList.get(i));
            TSDataType[] dataTypes = new TSDataType[((List)req.typesList.get(i)).size()];
            for (int j = 0; j < dataTypes.length; ++j) {
                dataTypes[j] = TSDataType.deserialize((byte)((byte)((Integer)((List)req.typesList.get(i)).get(j)).intValue()));
            }
            insertTabletStatement.setDataTypes(dataTypes);
            insertTabletStatement.setAligned(req.isAligned);
            if (insertTabletStatement.isEmpty()) continue;
            insertTabletStatementList.add(insertTabletStatement);
        }
        insertStatement.setInsertTabletStatementList(insertTabletStatementList);
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return insertStatement;
    }

    public static InsertRowsStatement createStatement(TSInsertRecordsReq req) throws IllegalPathException, QueryProcessException {
        long startTime = System.nanoTime();
        InsertRowsStatement insertStatement = new InsertRowsStatement();
        ArrayList<InsertRowStatement> insertRowStatementList = new ArrayList<InsertRowStatement>();
        for (int i = 0; i < req.prefixPaths.size(); ++i) {
            InsertRowStatement statement = new InsertRowStatement();
            statement.setDevicePath(DEVICE_PATH_CACHE.getPartialPath((String)req.getPrefixPaths().get(i)));
            statement.setMeasurements(((List)req.getMeasurementsList().get(i)).toArray(new String[0]));
            TimestampPrecisionUtils.checkTimestampPrecision((Long)req.getTimestamps().get(i));
            statement.setTime((Long)req.getTimestamps().get(i));
            statement.fillValues((ByteBuffer)req.valuesList.get(i));
            statement.setAligned(req.isAligned);
            if (statement.isEmpty()) continue;
            insertRowStatementList.add(statement);
        }
        insertStatement.setInsertRowStatementList(insertRowStatementList);
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return insertStatement;
    }

    public static InsertRowsStatement createStatement(TSInsertStringRecordsReq req) throws IllegalPathException {
        long startTime = System.nanoTime();
        InsertRowsStatement insertStatement = new InsertRowsStatement();
        ArrayList<InsertRowStatement> insertRowStatementList = new ArrayList<InsertRowStatement>();
        for (int i = 0; i < req.prefixPaths.size(); ++i) {
            InsertRowStatement statement = new InsertRowStatement();
            statement.setDevicePath(DEVICE_PATH_CACHE.getPartialPath((String)req.getPrefixPaths().get(i)));
            StatementGenerator.addMeasurementAndValue(statement, (List)req.getMeasurementsList().get(i), (List)req.getValuesList().get(i));
            statement.setDataTypes(new TSDataType[statement.getMeasurements().length]);
            TimestampPrecisionUtils.checkTimestampPrecision((Long)req.getTimestamps().get(i));
            statement.setTime((Long)req.getTimestamps().get(i));
            statement.setNeedInferType(true);
            statement.setAligned(req.isAligned);
            if (statement.isEmpty()) continue;
            insertRowStatementList.add(statement);
        }
        insertStatement.setInsertRowStatementList(insertRowStatementList);
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return insertStatement;
    }

    public static InsertRowsOfOneDeviceStatement createStatement(TSInsertRecordsOfOneDeviceReq req) throws IllegalPathException, QueryProcessException {
        long startTime = System.nanoTime();
        InsertRowsOfOneDeviceStatement insertStatement = new InsertRowsOfOneDeviceStatement();
        insertStatement.setDevicePath(DEVICE_PATH_CACHE.getPartialPath(req.prefixPath));
        ArrayList<InsertRowStatement> insertRowStatementList = new ArrayList<InsertRowStatement>();
        if (req.timestamps.size() != 0) {
            TimestampPrecisionUtils.checkTimestampPrecision((Long)req.timestamps.get(req.timestamps.size() - 1));
        }
        for (int i = 0; i < req.timestamps.size(); ++i) {
            InsertRowStatement statement = new InsertRowStatement();
            statement.setDevicePath(insertStatement.getDevicePath());
            statement.setMeasurements(((List)req.measurementsList.get(i)).toArray(new String[0]));
            statement.setTime((Long)req.timestamps.get(i));
            statement.fillValues((ByteBuffer)req.valuesList.get(i));
            statement.setAligned(req.isAligned);
            if (statement.isEmpty()) continue;
            insertRowStatementList.add(statement);
        }
        insertStatement.setInsertRowStatementList(insertRowStatementList);
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return insertStatement;
    }

    public static InsertRowsOfOneDeviceStatement createStatement(TSInsertStringRecordsOfOneDeviceReq req) throws IllegalPathException {
        long startTime = System.nanoTime();
        InsertRowsOfOneDeviceStatement insertStatement = new InsertRowsOfOneDeviceStatement();
        insertStatement.setDevicePath(DEVICE_PATH_CACHE.getPartialPath(req.prefixPath));
        ArrayList<InsertRowStatement> insertRowStatementList = new ArrayList<InsertRowStatement>();
        TimestampPrecisionUtils.checkTimestampPrecision((Long)req.timestamps.get(req.timestamps.size() - 1));
        for (int i = 0; i < req.timestamps.size(); ++i) {
            InsertRowStatement statement = new InsertRowStatement();
            statement.setDevicePath(insertStatement.getDevicePath());
            StatementGenerator.addMeasurementAndValue(statement, (List)req.getMeasurementsList().get(i), (List)req.getValuesList().get(i));
            statement.setDataTypes(new TSDataType[statement.getMeasurements().length]);
            statement.setTime((Long)req.timestamps.get(i));
            statement.setNeedInferType(true);
            statement.setAligned(req.isAligned);
            if (statement.isEmpty()) continue;
            insertRowStatementList.add(statement);
        }
        insertStatement.setInsertRowStatementList(insertRowStatementList);
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return insertStatement;
    }

    public static DatabaseSchemaStatement createStatement(String database) throws IllegalPathException {
        long startTime = System.nanoTime();
        DatabaseSchemaStatement statement = new DatabaseSchemaStatement(DatabaseSchemaStatement.DatabaseSchemaStatementType.CREATE);
        statement.setDatabasePath(StatementGenerator.parseDatabaseRawString(database));
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return statement;
    }

    public static CreateTimeSeriesStatement createStatement(TSCreateTimeseriesReq req) throws IllegalPathException {
        long startTime = System.nanoTime();
        CreateTimeSeriesStatement statement = new CreateTimeSeriesStatement();
        statement.setPath(new MeasurementPath(req.path));
        statement.setDataType(TSDataType.deserialize((byte)((byte)req.dataType)));
        statement.setEncoding(TSEncoding.deserialize((byte)((byte)req.encoding)));
        statement.setCompressor(CompressionType.deserialize((byte)((byte)req.compressor)));
        statement.setProps(req.props);
        statement.setTags(req.tags);
        statement.setAttributes(req.attributes);
        statement.setAlias(req.measurementAlias);
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return statement;
    }

    public static CreateAlignedTimeSeriesStatement createStatement(TSCreateAlignedTimeseriesReq req) throws IllegalPathException {
        long startTime = System.nanoTime();
        CreateAlignedTimeSeriesStatement statement = new CreateAlignedTimeSeriesStatement();
        statement.setDevicePath(DEVICE_PATH_CACHE.getPartialPath(req.prefixPath));
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (Object dataType : req.dataTypes) {
            dataTypes.add(TSDataType.deserialize((byte)((Integer)dataType).byteValue()));
        }
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        for (Integer encoding : req.encodings) {
            encodings.add(TSEncoding.deserialize((byte)encoding.byteValue()));
        }
        ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
        for (Integer compressor : req.compressors) {
            compressors.add(CompressionType.deserialize((byte)compressor.byteValue()));
        }
        statement.setMeasurements(req.measurements);
        statement.setDataTypes(dataTypes);
        statement.setEncodings(encodings);
        statement.setCompressors(compressors);
        statement.setTagsList(req.tagsList);
        statement.setAttributesList(req.attributesList);
        statement.setAliasList(req.measurementAlias);
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return statement;
    }

    public static CreateMultiTimeSeriesStatement createStatement(TSCreateMultiTimeseriesReq req) throws IllegalPathException {
        long startTime = System.nanoTime();
        ArrayList<MeasurementPath> paths = new ArrayList<MeasurementPath>();
        for (Object path : req.paths) {
            paths.add(new MeasurementPath((String)path));
        }
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (Object dataType : req.dataTypes) {
            dataTypes.add(TSDataType.deserialize((byte)((Integer)dataType).byteValue()));
        }
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        for (Object encoding : req.encodings) {
            encodings.add(TSEncoding.deserialize((byte)((Integer)encoding).byteValue()));
        }
        ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
        for (Integer compressor : req.compressors) {
            compressors.add(CompressionType.deserialize((byte)compressor.byteValue()));
        }
        CreateMultiTimeSeriesStatement statement = new CreateMultiTimeSeriesStatement();
        statement.setPaths(paths);
        statement.setDataTypes(dataTypes);
        statement.setEncodings(encodings);
        statement.setCompressors(compressors);
        statement.setPropsList(req.propsList);
        statement.setTagsList(req.tagsList);
        statement.setAttributesList(req.attributesList);
        statement.setAliasList(req.measurementAliasList);
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return statement;
    }

    public static DeleteDatabaseStatement createStatement(List<String> databases) throws IllegalPathException {
        long startTime = System.nanoTime();
        DeleteDatabaseStatement statement = new DeleteDatabaseStatement();
        for (String path : databases) {
            StatementGenerator.parseDatabaseRawString(path);
        }
        statement.setPrefixPath(databases);
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return statement;
    }

    public static DeleteDataStatement createStatement(TSDeleteDataReq req) throws IllegalPathException {
        long startTime = System.nanoTime();
        DeleteDataStatement statement = new DeleteDataStatement();
        ArrayList<MeasurementPath> pathList = new ArrayList<MeasurementPath>();
        for (String path : req.getPaths()) {
            pathList.add(new MeasurementPath(path));
        }
        statement.setPathList(pathList);
        statement.setDeleteStartTime(req.getStartTime());
        statement.setDeleteEndTime(req.getEndTime());
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return statement;
    }

    public static CreateSchemaTemplateStatement createStatement(TSCreateSchemaTemplateReq req) throws MetadataException {
        long startTime = System.nanoTime();
        ByteBuffer buffer = ByteBuffer.wrap(req.getSerializedTemplate());
        HashMap alignedPrefix = new HashMap();
        HashMap alignedDataTypes = new HashMap();
        HashMap alignedEncodings = new HashMap();
        HashMap alignedCompressions = new HashMap();
        ArrayList<List<String>> measurements = new ArrayList<List<String>>();
        ArrayList<List<TSDataType>> dataTypes = new ArrayList<List<TSDataType>>();
        ArrayList<List<TSEncoding>> encodings = new ArrayList<List<TSEncoding>>();
        ArrayList<List<CompressionType>> compressors = new ArrayList<List<CompressionType>>();
        ReadWriteIOUtils.readString((ByteBuffer)buffer);
        boolean isAlign = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        if (isAlign) {
            alignedPrefix.put("", new ArrayList());
            alignedDataTypes.put("", new ArrayList());
            alignedEncodings.put("", new ArrayList());
            alignedCompressions.put("", new ArrayList());
        }
        while (buffer.position() != buffer.limit()) {
            String prefix = ReadWriteIOUtils.readString((ByteBuffer)buffer);
            isAlign = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
            String string = ReadWriteIOUtils.readString((ByteBuffer)buffer);
            TSDataType dataType = TSDataType.deserialize((byte)ReadWriteIOUtils.readByte((ByteBuffer)buffer));
            TSEncoding encoding = TSEncoding.deserialize((byte)ReadWriteIOUtils.readByte((ByteBuffer)buffer));
            CompressionType compressionType = CompressionType.deserialize((byte)ReadWriteIOUtils.readByte((ByteBuffer)buffer));
            if (string == null) {
                throw new MetadataException("The name of a measurement in schema template shall not be null.");
            }
            if (alignedPrefix.containsKey(prefix) && !isAlign) {
                throw new MetadataException("Align designation incorrect at: " + (String)prefix);
            }
            if (isAlign && !alignedPrefix.containsKey(prefix)) {
                alignedPrefix.put(prefix, new ArrayList());
                alignedDataTypes.put(prefix, new ArrayList());
                alignedEncodings.put(prefix, new ArrayList());
                alignedCompressions.put(prefix, new ArrayList());
            }
            if (alignedPrefix.containsKey(prefix)) {
                ((List)alignedPrefix.get(prefix)).add(string);
                ((List)alignedDataTypes.get(prefix)).add(dataType);
                ((List)alignedEncodings.get(prefix)).add(encoding);
                ((List)alignedCompressions.get(prefix)).add(compressionType);
                continue;
            }
            if ("".equals(prefix)) {
                measurements.add(Collections.singletonList(string));
            } else {
                measurements.add(Collections.singletonList((String)prefix + "." + string));
            }
            dataTypes.add(Collections.singletonList(dataType));
            encodings.add(Collections.singletonList(encoding));
            compressors.add(Collections.singletonList(compressionType));
        }
        for (Map.Entry entry : alignedPrefix.entrySet()) {
            String prefix = (String)entry.getKey();
            List alignedMeasurements = (List)entry.getValue();
            ArrayList<String> thisMeasurements = new ArrayList<String>();
            ArrayList<TSDataType> thisDataTypes = new ArrayList<TSDataType>();
            ArrayList<TSEncoding> thisEncodings = new ArrayList<TSEncoding>();
            ArrayList<CompressionType> thisCompressors = new ArrayList<CompressionType>();
            for (int i = 0; i < alignedMeasurements.size(); ++i) {
                if ("".equals(prefix)) {
                    thisMeasurements.add((String)alignedMeasurements.get(i));
                } else {
                    thisMeasurements.add(prefix + "." + (String)alignedMeasurements.get(i));
                }
                thisDataTypes.add((TSDataType)((List)alignedDataTypes.get(prefix)).get(i));
                thisEncodings.add((TSEncoding)((List)alignedEncodings.get(prefix)).get(i));
                thisCompressors.add((CompressionType)((List)alignedCompressions.get(prefix)).get(i));
            }
            measurements.add(thisMeasurements);
            dataTypes.add(thisDataTypes);
            encodings.add(thisEncodings);
            compressors.add(thisCompressors);
        }
        CreateSchemaTemplateStatement statement = new CreateSchemaTemplateStatement(req.getName(), measurements, dataTypes, encodings, compressors, isAlign);
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return statement;
    }

    public static Statement createStatement(TSQueryTemplateReq req) {
        long startTime = System.nanoTime();
        ShowStatement result = null;
        switch (TemplateQueryType.values()[req.getQueryType()]) {
            case SHOW_MEASUREMENTS: {
                result = new ShowNodesInSchemaTemplateStatement(req.getName());
                break;
            }
            case SHOW_TEMPLATES: {
                result = new ShowSchemaTemplateStatement();
                break;
            }
            case SHOW_SET_TEMPLATES: {
                result = new ShowPathSetTemplateStatement(req.getName());
                break;
            }
            case SHOW_USING_TEMPLATES: {
                result = new ShowPathsUsingTemplateStatement(new PartialPath(SqlConstant.getSingleRootArray()), req.getName());
                break;
            }
        }
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return result;
    }

    public static SetSchemaTemplateStatement createStatement(TSSetSchemaTemplateReq req) throws IllegalPathException {
        long startTime = System.nanoTime();
        SetSchemaTemplateStatement statement = new SetSchemaTemplateStatement(req.getTemplateName(), new PartialPath(req.getPrefixPath()));
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return statement;
    }

    public static UnsetSchemaTemplateStatement createStatement(TSUnsetSchemaTemplateReq req) throws IllegalPathException {
        long startTime = System.nanoTime();
        UnsetSchemaTemplateStatement statement = new UnsetSchemaTemplateStatement(req.getTemplateName(), new PartialPath(req.getPrefixPath()));
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return statement;
    }

    public static DropSchemaTemplateStatement createStatement(TSDropSchemaTemplateReq req) {
        long startTime = System.nanoTime();
        DropSchemaTemplateStatement statement = new DropSchemaTemplateStatement(req.getTemplateName());
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return statement;
    }

    public static BatchActivateTemplateStatement createBatchActivateTemplateStatement(List<String> devicePathStringList) throws IllegalPathException {
        long startTime = System.nanoTime();
        ArrayList<PartialPath> devicePathList = new ArrayList<PartialPath>(devicePathStringList.size());
        for (String pathString : devicePathStringList) {
            devicePathList.add(new PartialPath(pathString));
        }
        BatchActivateTemplateStatement statement = new BatchActivateTemplateStatement(devicePathList);
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return statement;
    }

    public static DeleteTimeSeriesStatement createDeleteTimeSeriesStatement(List<String> pathPatternStringList) throws IllegalPathException {
        long startTime = System.nanoTime();
        ArrayList<PartialPath> pathPatternList = new ArrayList<PartialPath>();
        for (String pathPatternString : pathPatternStringList) {
            pathPatternList.add(new PartialPath(pathPatternString));
        }
        DeleteTimeSeriesStatement statement = new DeleteTimeSeriesStatement(pathPatternList);
        PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Statement invokeParser(String sql, ZoneId zoneId) {
        long startTime = System.nanoTime();
        try {
            IoTDBSqlParser.SingleStatementContext tree;
            ASTVisitor astVisitor = new ASTVisitor();
            astVisitor.setZoneId(zoneId);
            CodePointCharStream charStream1 = CharStreams.fromString((String)sql);
            SqlLexer lexer1 = new SqlLexer((CharStream)charStream1);
            lexer1.removeErrorListeners();
            lexer1.addErrorListener((ANTLRErrorListener)SqlParseError.INSTANCE);
            CommonTokenStream tokens1 = new CommonTokenStream((TokenSource)lexer1);
            IoTDBSqlParser parser1 = new IoTDBSqlParser((TokenStream)tokens1);
            ((ParserATNSimulator)parser1.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            parser1.removeErrorListeners();
            parser1.addErrorListener((ANTLRErrorListener)SqlParseError.INSTANCE);
            try {
                tree = parser1.singleStatement();
            }
            catch (Exception ex) {
                CodePointCharStream charStream2 = CharStreams.fromString((String)sql);
                SqlLexer lexer2 = new SqlLexer((CharStream)charStream2);
                lexer2.removeErrorListeners();
                lexer2.addErrorListener((ANTLRErrorListener)SqlParseError.INSTANCE);
                CommonTokenStream tokens2 = new CommonTokenStream((TokenSource)lexer2);
                IoTDBSqlParser parser2 = new IoTDBSqlParser((TokenStream)tokens2);
                ((ParserATNSimulator)parser2.getInterpreter()).setPredictionMode(PredictionMode.LL);
                parser2.removeErrorListeners();
                parser2.addErrorListener((ANTLRErrorListener)SqlParseError.INSTANCE);
                tree = parser2.singleStatement();
            }
            Statement statement = (Statement)astVisitor.visit((ParseTree)tree);
            return statement;
        }
        finally {
            PERFORMANCE_OVERVIEW_METRICS.recordParseCost(System.nanoTime() - startTime);
        }
    }

    private static void addMeasurementAndValue(InsertRowStatement insertRowStatement, List<String> measurements, List<String> values) {
        ArrayList<String> newMeasurements = new ArrayList<String>(measurements.size());
        ArrayList<String> newValues = new ArrayList<String>(values.size());
        for (int i = 0; i < measurements.size(); ++i) {
            String value = values.get(i);
            if (value.isEmpty()) continue;
            newMeasurements.add(measurements.get(i));
            newValues.add(value);
        }
        insertRowStatement.setValues(newValues.toArray(new Object[0]));
        insertRowStatement.setMeasurements(newMeasurements.toArray(new String[0]));
    }

    private static PartialPath parseDatabaseRawString(String database) throws IllegalPathException {
        PartialPath databasePath = new PartialPath(database);
        if (databasePath.getNodeLength() < 2) {
            throw new IllegalPathException(database);
        }
        MetaFormatUtils.checkDatabase(database);
        return databasePath;
    }

    public static Statement createStatement(TFetchTimeseriesReq fetchTimeseriesReq, ZoneId zoneId) {
        return StatementGenerator.invokeParser(fetchTimeseriesReq.getQueryBody(), zoneId);
    }
}

