/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.binary;

import java.nio.ByteBuffer;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.binary.BinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExpressionVisitor;

public abstract class CompareBinaryExpression
extends BinaryExpression {
    protected CompareBinaryExpression(Expression leftExpression, Expression rightExpression) {
        super(leftExpression, rightExpression);
    }

    protected CompareBinaryExpression(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    public static ExpressionType flipType(ExpressionType origin) {
        switch (origin) {
            case EQUAL_TO: 
            case NON_EQUAL: {
                return origin;
            }
            case GREATER_THAN: {
                return ExpressionType.LESS_THAN;
            }
            case GREATER_EQUAL: {
                return ExpressionType.LESS_EQUAL;
            }
            case LESS_THAN: {
                return ExpressionType.GREATER_THAN;
            }
            case LESS_EQUAL: {
                return ExpressionType.GREATER_EQUAL;
            }
        }
        throw new IllegalArgumentException("Unsupported expression type: " + (Object)((Object)origin));
    }

    @Override
    public boolean isCompareBinaryExpression() {
        return true;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitCompareBinaryExpression(this, context);
    }
}

