/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.session;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;

public class ShowCurrentDatabaseTask
implements IConfigTask {
    @Nullable
    private final String database;

    public ShowCurrentDatabaseTask(@Nullable String database) {
        this.database = database;
    }

    public static void buildTsBlock(String database, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.SHOW_CURRENT_DATABASE_COLUMN_HEADERS.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(outputDataTypes);
        tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
        if (database == null) {
            tsBlockBuilder.getColumnBuilder(0).appendNull();
        } else {
            tsBlockBuilder.getColumnBuilder(0).writeBinary(new Binary(database, TSFileConfig.STRING_CHARSET));
        }
        tsBlockBuilder.declarePosition();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, tsBlockBuilder.build(), DatasetHeaderFactory.getShowCurrentDatabaseHeader()));
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showCurrentDatabase(this.database);
    }
}

