/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.AbstractOperator;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.GroupedAggregator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.UpdateMemory;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.builder.HashAggregationBuilder;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.builder.InMemoryHashAggregationBuilder;
import org.apache.iotdb.db.queryengine.plan.planner.memory.MemoryReservationManager;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.RamUsageEstimator;

public class HashAggregationOperator
extends AbstractOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(HashAggregationOperator.class);
    private final Operator child;
    private final List<Type> groupByTypes;
    private final List<Integer> groupByChannels;
    private final List<GroupedAggregator> aggregators;
    private final AggregationNode.Step step;
    private final int expectedGroups;
    private final long maxPartialMemory;
    private final boolean spillEnabled;
    private final long unspillMemoryLimit;
    private HashAggregationBuilder aggregationBuilder;
    private final MemoryReservationManager memoryReservationManager;
    private long previousRetainedSize = 0L;
    private boolean finished = false;

    public HashAggregationOperator(OperatorContext operatorContext, Operator child, List<Type> groupByTypes, List<Integer> groupByChannels, List<GroupedAggregator> aggregators, AggregationNode.Step step, int expectedGroups, long maxPartialMemory, boolean spillEnabled, long unspillMemoryLimit) {
        this.operatorContext = operatorContext;
        this.child = child;
        this.groupByTypes = ImmutableList.copyOf(groupByTypes);
        this.groupByChannels = ImmutableList.copyOf(groupByChannels);
        this.aggregators = aggregators;
        this.step = step;
        this.expectedGroups = expectedGroups;
        this.maxPartialMemory = maxPartialMemory;
        this.spillEnabled = spillEnabled;
        this.unspillMemoryLimit = unspillMemoryLimit;
        this.memoryReservationManager = operatorContext.getDriverContext().getFragmentInstanceContext().getMemoryReservationContext();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public boolean hasNext() throws Exception {
        return !this.finished || this.retainedTsBlock != null;
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.retainedTsBlock != null) {
            return this.getResultFromRetainedTsBlock();
        }
        if (this.aggregationBuilder == null) {
            if (this.spillEnabled) {
                throw new UnsupportedOperationException();
            }
            this.aggregationBuilder = new InMemoryHashAggregationBuilder(this.aggregators, this.step, this.expectedGroups, this.groupByTypes, this.groupByChannels, Optional.empty(), this.operatorContext, this.maxPartialMemory, UpdateMemory.NOOP);
            this.updateOccupiedMemorySize();
        } else {
            Preconditions.checkState((!this.aggregationBuilder.isFull() ? 1 : 0) != 0, (Object)"Aggregation buffer is full");
        }
        if (this.child.hasNextWithTimer()) {
            TsBlock block = this.child.nextWithTimer();
            if (block == null) {
                return null;
            }
            this.aggregationBuilder.processBlock(block);
            this.aggregationBuilder.updateMemory();
            this.updateOccupiedMemorySize();
            return null;
        }
        this.resultTsBlock = this.getOutput();
        return this.checkTsBlockSizeAndGetResult();
    }

    private void updateOccupiedMemorySize() {
        long memorySize = this.aggregationBuilder.getEstimatedSize();
        this.operatorContext.recordSpecifiedInfo("CurrentUsedMemory", Long.toString(memorySize));
        long delta = memorySize - this.previousRetainedSize;
        if (delta > 0L) {
            this.memoryReservationManager.reserveMemoryCumulatively(delta);
        } else if (delta < 0L) {
            this.memoryReservationManager.releaseMemoryCumulatively(-delta);
        }
        this.previousRetainedSize = memorySize;
    }

    private TsBlock getOutput() {
        Preconditions.checkState((this.aggregationBuilder != null ? 1 : 0) != 0);
        TsBlock result = this.aggregationBuilder.buildResult();
        if (this.aggregationBuilder.finished()) {
            this.closeAggregationBuilder();
            this.finished = true;
        }
        return result;
    }

    private void closeAggregationBuilder() {
        if (this.aggregationBuilder != null) {
            this.aggregationBuilder.close();
            this.aggregationBuilder = null;
        }
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.finished && this.retainedTsBlock == null;
    }

    @Override
    public void close() throws Exception {
        this.child.close();
        this.aggregators.forEach(GroupedAggregator::close);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return Math.max(this.child.calculateMaxPeekMemoryWithCounter(), this.calculateRetainedSizeAfterCallingNext() + this.calculateMaxReturnSize());
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateMaxReturnSize() + this.child.calculateRetainedSizeAfterCallingNext();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.child) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext);
    }
}

