/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AbstractApproxMostFrequentAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationMask;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate.Counter;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate.SpaceSaving;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate.SpaceSavingStateFactory;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class BooleanApproxMostFrequentAccumulator
extends AbstractApproxMostFrequentAccumulator<Boolean> {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(BooleanApproxMostFrequentAccumulator.class);

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE + RamUsageEstimator.shallowSizeOfInstance(BooleanApproxMostFrequentAccumulator.class) + this.state.getEstimatedSize();
    }

    @Override
    public TableAccumulator copy() {
        return new BooleanApproxMostFrequentAccumulator();
    }

    @Override
    public void addInput(Column[] arguments, AggregationMask mask) {
        int maxBuckets = arguments[1].getInt(0);
        int capacity = arguments[2].getInt(0);
        if (maxBuckets <= 0 || capacity <= 0) {
            throw new SemanticException("The second and third argument must be greater than 0, but got k=" + maxBuckets + ", capacity=" + capacity);
        }
        SpaceSaving<Boolean> spaceSaving = BooleanApproxMostFrequentAccumulator.getOrCreateSpaceSaving(this.state, maxBuckets, capacity);
        int positionCount = mask.getPositionCount();
        Column valueColumn = arguments[0];
        if (mask.isSelectAll()) {
            for (int i = 0; i < valueColumn.getPositionCount(); ++i) {
                if (valueColumn.isNull(i)) continue;
                spaceSaving.add(valueColumn.getBoolean(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                spaceSaving.add(valueColumn.getBoolean(position));
            }
        }
    }

    @Override
    public void addIntermediate(Column argument) {
        for (int i = 0; i < argument.getPositionCount(); ++i) {
            if (argument.isNull(i)) continue;
            SpaceSaving<Boolean> current = new SpaceSaving<Boolean>(argument.getBinary(i).getValues(), BooleanApproxMostFrequentAccumulator::serializeBucket, BooleanApproxMostFrequentAccumulator::deserializeBucket, BooleanApproxMostFrequentAccumulator::calculateKeyByte);
            this.state.merge(current);
        }
    }

    public static SpaceSaving<Boolean> getOrCreateSpaceSaving(SpaceSavingStateFactory.SingleSpaceSavingState<Boolean> state, int maxBuckets, int capacity) {
        SpaceSaving<Boolean> spaceSaving = state.getSpaceSaving();
        if (spaceSaving == null) {
            spaceSaving = new SpaceSaving<Boolean>(maxBuckets, capacity, BooleanApproxMostFrequentAccumulator::serializeBucket, BooleanApproxMostFrequentAccumulator::deserializeBucket, BooleanApproxMostFrequentAccumulator::calculateKeyByte);
            state.setSpaceSaving(spaceSaving);
        }
        return spaceSaving;
    }

    public static void serializeBucket(Boolean key, long count, ByteBuffer output) {
        ReadWriteIOUtils.write((Boolean)key, (ByteBuffer)output);
        ReadWriteIOUtils.write((long)count, (ByteBuffer)output);
    }

    public static void deserializeBucket(ByteBuffer input, SpaceSaving<Boolean> spaceSaving) {
        boolean key = ReadWriteIOUtils.readBoolean((ByteBuffer)input);
        long count = ReadWriteIOUtils.readLong((ByteBuffer)input);
        spaceSaving.add(key, count);
    }

    public static int calculateKeyByte(List<Counter<Boolean>> counters) {
        return counters.stream().mapToInt(counter -> 1).sum();
    }
}

