/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.AbstractAggTableScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.LastAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.LastByDescAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.LastDescAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAggregator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.Utils;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.DeviceEntry;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TableDeviceLastCache;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TableDeviceSchemaCache;
import org.apache.iotdb.db.queryengine.plan.relational.type.InternalTypeManager;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class LastQueryAggTableScanOperator
extends AbstractAggTableScanOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(LastQueryAggTableScanOperator.class);
    private static final TableDeviceSchemaCache TABLE_DEVICE_SCHEMA_CACHE = TableDeviceSchemaCache.getInstance();
    private final String dbName;
    private int outputDeviceIndex;
    private DeviceEntry currentDeviceEntry;
    private final List<DeviceEntry> cachedDeviceEntries;
    private final int allDeviceCount;
    private final boolean needUpdateCache;
    private final boolean needUpdateNullEntry;
    private final List<Integer> hitCachesIndexes;
    private final List<Pair<OptionalLong, TsPrimitiveType[]>> hitCachedResults;
    private int currentHitCacheIndex = 0;
    private int lastTimeAggregationIdx = -1;

    public LastQueryAggTableScanOperator(AbstractAggTableScanOperator.AbstractAggTableScanOperatorParameter parameter, List<DeviceEntry> cachedDeviceEntries, QualifiedObjectName qualifiedObjectName, List<Integer> hitCachesIndexes, List<Pair<OptionalLong, TsPrimitiveType[]>> hitCachedResults) {
        super(parameter);
        this.allDeviceCount = cachedDeviceEntries.size() + parameter.deviceCount;
        this.cachedDeviceEntries = cachedDeviceEntries;
        this.needUpdateCache = LastQueryUtil.needUpdateCache(parameter.seriesScanOptions.getGlobalTimeFilter());
        this.needUpdateNullEntry = LastQueryUtil.needUpdateNullEntry(parameter.seriesScanOptions.getGlobalTimeFilter());
        this.hitCachesIndexes = hitCachesIndexes;
        this.hitCachedResults = hitCachedResults;
        this.dbName = qualifiedObjectName.getDatabaseName();
        this.operatorContext.recordSpecifiedInfo("CachedDeviceNumber", Integer.toString(cachedDeviceEntries.size()));
        for (int i = 0; i < parameter.tableAggregators.size(); ++i) {
            if (!(parameter.tableAggregators.get(i).getAccumulator() instanceof LastAccumulator)) continue;
            this.lastTimeAggregationIdx = i;
        }
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.retainedTsBlock != null) {
            return true;
        }
        return this.outputDeviceIndex < this.allDeviceCount;
    }

    @Override
    public TsBlock next() throws Exception {
        long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        long start = System.nanoTime();
        if (this.retainedTsBlock != null) {
            return this.getResultFromRetainedTsBlock();
        }
        while (System.nanoTime() - start < maxRuntime && !this.resultTsBlockBuilder.isFull() && this.outputDeviceIndex < this.allDeviceCount) {
            this.processCurrentDevice();
        }
        if (this.resultTsBlockBuilder.isEmpty()) {
            return null;
        }
        this.buildResultTsBlock();
        return this.checkTsBlockSizeAndGetResult();
    }

    private void processCurrentDevice() {
        if (this.currentHitCacheIndex < this.hitCachesIndexes.size() && this.outputDeviceIndex == this.hitCachesIndexes.get(this.currentHitCacheIndex)) {
            this.currentDeviceEntry = this.cachedDeviceEntries.get(this.currentHitCacheIndex);
            this.buildResultUseLastCache();
            return;
        }
        Optional<Boolean> b = this.calculateAggregationResultForCurrentTimeRange();
        if (b.isPresent() && b.get().booleanValue()) {
            this.timeIterator.resetCurTimeRange();
        }
    }

    private void buildResultUseLastCache() {
        this.appendGroupKeysToResult(this.cachedDeviceEntries, this.currentHitCacheIndex);
        Pair<OptionalLong, TsPrimitiveType[]> currentHitResult = this.hitCachedResults.get(this.currentHitCacheIndex);
        long lastTime = ((OptionalLong)currentHitResult.getLeft()).getAsLong();
        int channel = 0;
        for (int i = 0; i < this.tableAggregators.size(); ++i) {
            TableAggregator aggregator = (TableAggregator)this.tableAggregators.get(i);
            ColumnBuilder columnBuilder = this.resultTsBlockBuilder.getColumnBuilder(this.groupingKeySize + i);
            int columnIdx = (Integer)this.aggregatorInputChannels.get(channel);
            ColumnSchema schema = (ColumnSchema)this.aggColumnSchemas.get(columnIdx);
            TsTableColumnCategory category = schema.getColumnCategory();
            switch (category) {
                case TAG: {
                    String id = this.getNthIdColumnValue(this.cachedDeviceEntries.get(this.currentHitCacheIndex), this.aggColumnsIndexArray[columnIdx]);
                    if (id == null) {
                        if (aggregator.getStep().isOutputPartial()) {
                            columnBuilder.writeBinary(new Binary(Utils.serializeTimeValue(InternalTypeManager.getTSDataType(schema.getType()), lastTime, true, null)));
                            break;
                        }
                        columnBuilder.appendNull();
                        break;
                    }
                    if (aggregator.getStep().isOutputPartial()) {
                        columnBuilder.writeBinary(new Binary(Utils.serializeTimeValue(InternalTypeManager.getTSDataType(schema.getType()), lastTime, false, (TsPrimitiveType)new TsPrimitiveType.TsBinary(new Binary(id, TSFileConfig.STRING_CHARSET)))));
                        break;
                    }
                    columnBuilder.writeBinary(new Binary(id, TSFileConfig.STRING_CHARSET));
                    break;
                }
                case ATTRIBUTE: {
                    Binary attribute = this.cachedDeviceEntries.get(this.currentHitCacheIndex).getAttributeColumnValues()[this.aggColumnsIndexArray[columnIdx]];
                    if (attribute == null) {
                        if (aggregator.getStep().isOutputPartial()) {
                            columnBuilder.writeBinary(new Binary(Utils.serializeTimeValue(InternalTypeManager.getTSDataType(schema.getType()), lastTime, true, null)));
                            break;
                        }
                        columnBuilder.appendNull();
                        break;
                    }
                    if (aggregator.getStep().isOutputPartial()) {
                        columnBuilder.writeBinary(new Binary(Utils.serializeTimeValue(InternalTypeManager.getTSDataType(schema.getType()), lastTime, false, (TsPrimitiveType)new TsPrimitiveType.TsBinary(attribute))));
                        break;
                    }
                    columnBuilder.writeBinary(attribute);
                    break;
                }
                case TIME: {
                    if (aggregator.getAccumulator() instanceof LastDescAccumulator) {
                        if (aggregator.getStep().isOutputPartial()) {
                            columnBuilder.writeBinary(new Binary(Utils.serializeTimeValue(InternalTypeManager.getTSDataType(schema.getType()), lastTime, (TsPrimitiveType)new TsPrimitiveType.TsLong(lastTime))));
                            break;
                        }
                        columnBuilder.writeTsPrimitiveType((TsPrimitiveType)new TsPrimitiveType.TsLong(lastTime));
                        break;
                    }
                    if (aggregator.getStep().isOutputPartial()) {
                        columnBuilder.writeBinary(new Binary(Utils.serializeTimeValue(InternalTypeManager.getTSDataType(schema.getType()), lastTime, false, (TsPrimitiveType)new TsPrimitiveType.TsLong(lastTime))));
                        break;
                    }
                    columnBuilder.writeTsPrimitiveType((TsPrimitiveType)new TsPrimitiveType.TsLong(lastTime));
                    break;
                }
                case FIELD: {
                    int measurementIdx = this.aggColumnsIndexArray[(Integer)this.aggregatorInputChannels.get(channel)];
                    TsPrimitiveType tsPrimitiveType = ((TsPrimitiveType[])this.hitCachedResults.get(this.currentHitCacheIndex).getRight())[measurementIdx];
                    long lastByTime = ((OptionalLong)this.hitCachedResults.get(this.currentHitCacheIndex).getLeft()).getAsLong();
                    if (tsPrimitiveType == TableDeviceLastCache.EMPTY_PRIMITIVE_TYPE) {
                        if (aggregator.getStep().isOutputPartial()) {
                            columnBuilder.writeBinary(new Binary(Utils.serializeTimeValue(InternalTypeManager.getTSDataType(schema.getType()), lastByTime, true, null)));
                            break;
                        }
                        columnBuilder.appendNull();
                        break;
                    }
                    if (aggregator.getStep().isOutputPartial()) {
                        columnBuilder.writeBinary(new Binary(Utils.serializeTimeValue(InternalTypeManager.getTSDataType(schema.getType()), lastByTime, false, tsPrimitiveType)));
                        break;
                    }
                    columnBuilder.writeTsPrimitiveType(tsPrimitiveType);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported category: " + category);
                }
            }
            channel += aggregator.getChannelCount();
        }
        this.resultTsBlockBuilder.declarePosition();
        ++this.outputDeviceIndex;
        ++this.currentHitCacheIndex;
    }

    private void updateLastCacheIfPossible() {
        if (!this.needUpdateCache) {
            return;
        }
        int channel = 0;
        ArrayList<String> updateMeasurementList = new ArrayList<String>();
        ArrayList<TimeValuePair> updateTimeValuePairList = new ArrayList<TimeValuePair>();
        boolean hasSetLastTime = false;
        for (int i = 0; i < this.tableAggregators.size(); ++i) {
            TableAggregator tableAggregator = (TableAggregator)this.tableAggregators.get(i);
            ColumnSchema schema = (ColumnSchema)this.aggColumnSchemas.get((Integer)this.aggregatorInputChannels.get(channel));
            switch (schema.getColumnCategory()) {
                case TIME: {
                    if (hasSetLastTime) break;
                    hasSetLastTime = true;
                    if (i == this.lastTimeAggregationIdx) {
                        LastDescAccumulator lastAccumulator = (LastDescAccumulator)tableAggregator.getAccumulator();
                        if (!lastAccumulator.hasInitResult()) break;
                        updateMeasurementList.add("");
                        updateTimeValuePairList.add(new TimeValuePair(lastAccumulator.getMaxTime(), (TsPrimitiveType)new TsPrimitiveType.TsLong(lastAccumulator.getMaxTime())));
                        break;
                    }
                    LastByDescAccumulator lastByAccumulator = (LastByDescAccumulator)tableAggregator.getAccumulator();
                    if (!lastByAccumulator.hasInitResult() || lastByAccumulator.isXNull()) break;
                    updateMeasurementList.add("");
                    updateTimeValuePairList.add(new TimeValuePair(lastByAccumulator.getLastTimeOfY(), (TsPrimitiveType)new TsPrimitiveType.TsLong(lastByAccumulator.getLastTimeOfY())));
                    break;
                }
                case FIELD: {
                    LastByDescAccumulator lastByAccumulator = (LastByDescAccumulator)tableAggregator.getAccumulator();
                    if (!lastByAccumulator.hasInitResult() || lastByAccumulator.isXNull()) break;
                    long lastByTime = lastByAccumulator.getLastTimeOfY();
                    if (!hasSetLastTime) {
                        hasSetLastTime = true;
                        updateMeasurementList.add("");
                        updateTimeValuePairList.add(new TimeValuePair(lastByTime, (TsPrimitiveType)new TsPrimitiveType.TsLong(lastByTime)));
                    }
                    updateMeasurementList.add(schema.getName());
                    updateTimeValuePairList.add(new TimeValuePair(lastByTime, this.cloneTsPrimitiveType(lastByAccumulator.getXResult())));
                    break;
                }
            }
            channel += tableAggregator.getChannelCount();
        }
        if (!updateMeasurementList.isEmpty()) {
            String[] updateMeasurementArray = updateMeasurementList.toArray(new String[0]);
            TimeValuePair[] updateTimeValuePairArray = updateTimeValuePairList.toArray(new TimeValuePair[0]);
            this.currentDeviceEntry = (DeviceEntry)this.deviceEntries.get(this.currentDeviceIndex);
            TABLE_DEVICE_SCHEMA_CACHE.updateLastCacheIfExists(this.dbName, this.currentDeviceEntry.getDeviceID(), updateMeasurementArray, updateTimeValuePairArray);
        }
    }

    @Override
    protected void updateResultTsBlock() {
        this.appendAggregationResult();
        if (this.timeIterator.hasCachedTimeRange()) {
            this.updateLastCacheIfPossible();
        }
        ++this.outputDeviceIndex;
        this.resetTableAggregators();
    }

    @Override
    String getNthIdColumnValue(DeviceEntry deviceEntry, int idColumnIndex) {
        return (String)deviceEntry.getNthSegment(idColumnIndex + 1);
    }

    private TsPrimitiveType cloneTsPrimitiveType(TsPrimitiveType originalValue) {
        switch (originalValue.getDataType()) {
            case BOOLEAN: {
                return new TsPrimitiveType.TsBoolean(originalValue.getBoolean());
            }
            case INT32: 
            case DATE: {
                return new TsPrimitiveType.TsInt(originalValue.getInt());
            }
            case INT64: 
            case TIMESTAMP: {
                return new TsPrimitiveType.TsLong(originalValue.getLong());
            }
            case FLOAT: {
                return new TsPrimitiveType.TsFloat(originalValue.getFloat());
            }
            case DOUBLE: {
                return new TsPrimitiveType.TsDouble(originalValue.getDouble());
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                return new TsPrimitiveType.TsBinary(originalValue.getBinary());
            }
            case VECTOR: {
                return new TsPrimitiveType.TsVector(originalValue.getVector());
            }
        }
        throw new UnSupportedDataTypeException("Unsupported data type:" + originalValue.getDataType());
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.seriesScanUtil) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.sourceId) + (this.resultTsBlockBuilder == null ? 0L : this.resultTsBlockBuilder.getRetainedSizeInBytes()) + RamUsageEstimator.sizeOfCollection((Collection)this.deviceEntries) + RamUsageEstimator.sizeOfCollection(this.cachedDeviceEntries) + RamUsageEstimator.sizeOfCollection(this.hitCachedResults);
    }
}

