/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema.source;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.exception.runtime.SchemaExecutionException;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.db.schemaengine.rescon.ISchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.ISchemaReader;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;

public class TableDeviceFetchSource
implements ISchemaSource<IDeviceSchemaInfo> {
    private final String database;
    private final String tableName;
    private final List<Object[]> deviceIdList;
    private final List<ColumnHeader> columnHeaderList;

    public TableDeviceFetchSource(String database, String tableName, List<Object[]> deviceIdList, List<ColumnHeader> columnHeaderList) {
        this.database = database;
        this.tableName = tableName;
        this.deviceIdList = deviceIdList;
        this.columnHeaderList = columnHeaderList;
    }

    @Override
    public ISchemaReader<IDeviceSchemaInfo> getSchemaReader(ISchemaRegion schemaRegion) {
        try {
            return schemaRegion.getTableDeviceReader(this.tableName, this.deviceIdList);
        }
        catch (MetadataException e) {
            throw new SchemaExecutionException((Throwable)e);
        }
    }

    @Override
    public List<ColumnHeader> getInfoQueryColumnHeaders() {
        return this.columnHeaderList;
    }

    @Override
    public void transformToTsBlockColumns(IDeviceSchemaInfo schemaInfo, TsBlockBuilder builder, String database) {
        builder.getTimeColumnBuilder().writeLong(0L);
        int resultIndex = 0;
        int idIndex = 0;
        String[] pathNodes = schemaInfo.getRawNodes();
        TsTable table = DataNodeTableCache.getInstance().getTable(this.database, this.tableName);
        for (ColumnHeader columnHeader : this.columnHeaderList) {
            TsTableColumnSchema columnSchema = table.getColumnSchema(columnHeader.getColumnName());
            if (columnSchema.getColumnCategory().equals((Object)TsTableColumnCategory.TAG)) {
                if (pathNodes.length <= idIndex + 3 || pathNodes[idIndex + 3] == null) {
                    builder.getColumnBuilder(resultIndex).appendNull();
                } else {
                    builder.getColumnBuilder(resultIndex).writeBinary(new Binary(pathNodes[idIndex + 3], TSFileConfig.STRING_CHARSET));
                }
                ++idIndex;
            } else if (columnSchema.getColumnCategory().equals((Object)TsTableColumnCategory.ATTRIBUTE)) {
                if (Objects.isNull(schemaInfo.getAttributeValue(columnHeader.getColumnName()))) {
                    builder.getColumnBuilder(resultIndex).appendNull();
                } else {
                    builder.getColumnBuilder(resultIndex).writeBinary(schemaInfo.getAttributeValue(columnHeader.getColumnName()));
                }
            }
            ++resultIndex;
        }
        builder.declarePosition();
    }

    @Override
    public boolean hasSchemaStatistic(ISchemaRegion schemaRegion) {
        return false;
    }

    @Override
    public long getSchemaStatistic(ISchemaRegion schemaRegion) {
        return 0L;
    }

    @Override
    public long getMaxMemory(ISchemaRegion schemaRegion) {
        ISchemaRegionStatistics statistics = schemaRegion.getSchemaRegionStatistics();
        long devicesNumber = statistics.getTableDevicesNumber(this.tableName);
        return Math.min((long)TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes(), this.deviceIdList.stream().flatMap(Arrays::stream).map(segment -> RamUsageEstimator.sizeOf((String)String.valueOf(segment))).reduce(0L, Long::sum) + (devicesNumber > 0L ? (long)this.deviceIdList.size() * statistics.getTableAttributeMemory(this.tableName) / devicesNumber : 0L));
    }
}

