/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern;

import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.PatternAggregationTracker;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher.ArrayView;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.Partition;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.AbstractTableScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationMask;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.iotdb.db.queryengine.plan.relational.function.BoundSignature;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;

public class PatternAggregator {
    private final BoundSignature boundSignature;
    private final TableAccumulator accumulator;
    private List<Integer> argumentChannels;
    private PatternAggregationTracker patternAggregationTracker;

    public PatternAggregator(BoundSignature boundSignature, TableAccumulator accumulator, List<Integer> argumentChannels, PatternAggregationTracker patternAggregationTracker) {
        this.boundSignature = Objects.requireNonNull(boundSignature, "boundSignature is null");
        this.accumulator = Objects.requireNonNull(accumulator, "accumulato is null");
        this.argumentChannels = argumentChannels;
        this.patternAggregationTracker = Objects.requireNonNull(patternAggregationTracker, "patternAggregationTracker is null");
        accumulator.reset();
    }

    public void reset() {
        this.accumulator.reset();
        this.patternAggregationTracker.reset();
    }

    public Object aggregate(int currentRow, ArrayView matchedLabels, Partition partition, int partitionStart, int patternStart) {
        ArrayView positions = this.patternAggregationTracker.resolveNewPositions(currentRow, matchedLabels, partitionStart, patternStart);
        AggregationMask mask = AggregationMask.createSelectedPositions(partition.getPositionCount(), positions.toArray(), positions.length());
        if (this.argumentChannels.isEmpty()) {
            Column[] arguments = new Column[]{new RunLengthEncodedColumn((Column)AbstractTableScanOperator.TIME_COLUMN_TEMPLATE, partition.getPositionCount())};
            this.accumulator.addInput(arguments, mask);
        } else {
            int argCount = this.argumentChannels.size();
            Column[] argumentColumns = new Column[argCount];
            for (int i = 0; i < argCount; ++i) {
                int channel = this.argumentChannels.get(i);
                ColumnBuilder builder = this.boundSignature.getArgumentType(i).createColumnBuilder(partition.getPositionCount());
                for (int row = 0; row < partition.getPositionCount(); ++row) {
                    partition.writeTo(builder, channel, row);
                }
                argumentColumns[i] = builder.build();
            }
            this.accumulator.addInput(argumentColumns, mask);
        }
        ColumnBuilder resultBuilder = this.boundSignature.getReturnType().createColumnBuilder(1);
        this.accumulator.evaluateFinal(resultBuilder);
        return resultBuilder.build().getObject(0);
    }

    public PatternAggregator copy() {
        TableAccumulator accumulatorCopy;
        try {
            accumulatorCopy = this.accumulator.copy();
        }
        catch (UnsupportedOperationException e) {
            throw new SemanticException(String.format("aggregate function %s does not support copying", this.boundSignature.getName()));
        }
        return new PatternAggregator(this.boundSignature, accumulatorCopy, this.argumentChannels, this.patternAggregationTracker.copy());
    }
}

