/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.fill.previous;

import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.IFill;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.column.DoubleColumn;
import org.apache.tsfile.read.common.block.column.DoubleColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;

public class DoublePreviousFill
implements IFill {
    private double value;
    private long previousTime;
    private boolean previousIsNull = true;

    @Override
    public Column fill(Column timeColumn, Column valueColumn) {
        int size = valueColumn.getPositionCount();
        if (size == 0) {
            return valueColumn;
        }
        if (!valueColumn.mayHaveNull()) {
            this.previousIsNull = false;
            this.previousTime = timeColumn.getLong(size - 1);
            this.value = valueColumn.getDouble(size - 1);
            return valueColumn;
        }
        if (valueColumn instanceof RunLengthEncodedColumn) {
            if (this.previousIsNull) {
                return new RunLengthEncodedColumn((Column)DoubleColumnBuilder.NULL_VALUE_BLOCK, size);
            }
            return new RunLengthEncodedColumn((Column)new DoubleColumn(1, Optional.empty(), new double[]{this.value}), size);
        }
        double[] array = new double[size];
        boolean[] isNull = new boolean[size];
        boolean hasNullValue = false;
        for (int i = 0; i < size; ++i) {
            if (valueColumn.isNull(i)) {
                if (this.previousIsNull) {
                    isNull[i] = true;
                    hasNullValue = true;
                    continue;
                }
                array[i] = this.value;
                continue;
            }
            array[i] = valueColumn.getDouble(i);
            this.previousTime = timeColumn.getLong(i);
            this.value = array[i];
            this.previousIsNull = false;
        }
        if (hasNullValue) {
            return new DoubleColumn(size, Optional.of(isNull), array);
        }
        return new DoubleColumn(size, Optional.empty(), array);
    }

    @Override
    public void reset() {
        this.previousIsNull = true;
    }
}

