/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.ILinearFill;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.RamUsageEstimator;

abstract class AbstractLinearFillOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(AbstractLinearFillOperator.class);
    private final OperatorContext operatorContext;
    protected final ILinearFill[] fillArray;
    private final Operator child;
    protected final int outputColumnCount;
    private final List<TsBlock> cachedTsBlock;
    private final List<Long> cachedRowIndex;
    private final List<Integer> cachedLastRowIndexForNonNullHelperColumn;
    private long currentRowIndex = 0L;
    private final int[] nextTsBlockIndex;
    private boolean canCallNext;
    protected boolean noMoreTsBlock;

    AbstractLinearFillOperator(OperatorContext operatorContext, ILinearFill[] fillArray, Operator child) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        Preconditions.checkArgument((fillArray != null && fillArray.length > 0 ? 1 : 0) != 0, (Object)"fillArray should not be null or empty");
        this.fillArray = fillArray;
        this.child = Objects.requireNonNull(child, "child operator is null");
        this.outputColumnCount = fillArray.length;
        this.cachedTsBlock = new ArrayList<TsBlock>();
        this.cachedRowIndex = new ArrayList<Long>();
        this.cachedLastRowIndexForNonNullHelperColumn = new ArrayList<Integer>();
        this.nextTsBlockIndex = new int[this.outputColumnCount];
        Arrays.fill(this.nextTsBlockIndex, 1);
        this.canCallNext = false;
        this.noMoreTsBlock = true;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.cachedTsBlock.isEmpty() && !this.tryToGetNextTsBlock()) {
            return null;
        }
        TsBlock tempResult = null;
        while (tempResult == null && !this.cachedTsBlock.isEmpty()) {
            int i;
            TsBlock originTsBlock = this.cachedTsBlock.get(0);
            long currentEndRowIndex = this.cachedRowIndex.get(0) + (long)this.cachedLastRowIndexForNonNullHelperColumn.get(0).intValue();
            block1: for (int columnIndex = 0; columnIndex < this.outputColumnCount; ++columnIndex) {
                if (!this.fillArray[columnIndex].needPrepareForNext(currentEndRowIndex, originTsBlock.getColumn(columnIndex), this.cachedLastRowIndexForNonNullHelperColumn.get(0))) continue;
                while (!this.isCachedTsBlockEnough(columnIndex, currentEndRowIndex)) {
                    if (this.tryToGetNextTsBlock()) continue;
                    if (this.noMoreTsBlockForCurrentGroup()) continue block1;
                    return this.buildFinalResult(tempResult);
                }
            }
            originTsBlock = this.cachedTsBlock.remove(0);
            long startRowIndex = this.cachedRowIndex.remove(0);
            this.cachedLastRowIndexForNonNullHelperColumn.remove(0);
            this.resetFill();
            Column[] columns = new Column[this.outputColumnCount];
            for (i = 0; i < this.outputColumnCount; ++i) {
                columns[i] = this.fillArray[i].fill(this.getHelperColumn(originTsBlock), originTsBlock.getColumn(i), startRowIndex);
            }
            tempResult = this.append(originTsBlock.getPositionCount(), originTsBlock.getTimeColumn(), columns);
            for (i = 0; i < this.outputColumnCount; ++i) {
                this.nextTsBlockIndex[i] = Math.max(1, this.nextTsBlockIndex[i] - 1);
            }
        }
        return this.buildFinalResult(tempResult);
    }

    boolean noMoreTsBlockForCurrentGroup() {
        return this.noMoreTsBlock;
    }

    abstract Column getHelperColumn(TsBlock var1);

    abstract Integer getLastRowIndexForNonNullHelperColumn(TsBlock var1);

    TsBlock append(int length, Column timeColumn, Column[] valueColumns) {
        return new TsBlock(length, timeColumn, valueColumns);
    }

    TsBlock buildFinalResult(TsBlock tempResult) {
        return tempResult;
    }

    void resetFill() {
    }

    @Override
    public boolean hasNext() throws Exception {
        this.noMoreTsBlock = !this.child.hasNextWithTimer();
        this.canCallNext = !this.noMoreTsBlock;
        return !this.cachedTsBlock.isEmpty() || !this.noMoreTsBlock;
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.cachedTsBlock.isEmpty() && this.child.isFinished();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return 3L * this.child.calculateMaxPeekMemory() + this.child.calculateRetainedSizeAfterCallingNext();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.child.calculateMaxReturnSize();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateRetainedSizeAfterCallingNext();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.child) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + RamUsageEstimator.sizeOf((int[])this.nextTsBlockIndex);
    }

    private boolean isCachedTsBlockEnough(int columnIndex, long currentEndRowIndex) {
        while (this.nextTsBlockIndex[columnIndex] < this.cachedTsBlock.size()) {
            TsBlock nextTsBlock = this.cachedTsBlock.get(this.nextTsBlockIndex[columnIndex]);
            long startRowIndex = this.cachedRowIndex.get(this.nextTsBlockIndex[columnIndex]);
            int n = columnIndex;
            this.nextTsBlockIndex[n] = this.nextTsBlockIndex[n] + 1;
            if (!this.fillArray[columnIndex].prepareForNext(startRowIndex, currentEndRowIndex, this.getHelperColumn(nextTsBlock), nextTsBlock.getColumn(columnIndex))) continue;
            return true;
        }
        return false;
    }

    private boolean tryToGetNextTsBlock() throws Exception {
        if (this.canCallNext) {
            this.canCallNext = false;
            TsBlock nextTsBlock = this.child.nextWithTimer();
            if (nextTsBlock == null || nextTsBlock.isEmpty()) {
                return false;
            }
            this.updateCachedData(nextTsBlock);
            return true;
        }
        return false;
    }

    void updateCachedData(TsBlock tsBlock) {
        this.cachedTsBlock.add(tsBlock);
        this.cachedRowIndex.add(this.currentRowIndex);
        this.cachedLastRowIndexForNonNullHelperColumn.add(this.getLastRowIndexForNonNullHelperColumn(tsBlock));
        this.currentRowIndex += (long)tsBlock.getPositionCount();
    }
}

