/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.twostage.combiner;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.cluster.RegionRoleType;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.confignode.rpc.thrift.TRegionInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionResp;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.processor.twostage.combiner.Combiner;
import org.apache.iotdb.db.pipe.processor.twostage.exchange.payload.FetchCombineResultResponse;
import org.apache.iotdb.db.pipe.processor.twostage.operator.Operator;
import org.apache.iotdb.db.pipe.processor.twostage.state.State;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeCombineHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeCombineHandler.class);
    private final String pipeName;
    private final long creationTime;
    private final Function<String, Operator> operatorConstructor;
    private static final Map<Integer, Integer> ALL_REGION_ID_2_DATANODE_ID_MAP = new HashMap<Integer, Integer>();
    private static final AtomicLong ALL_REGION_ID_2_DATANODE_ID_MAP_LAST_UPDATE_TIME = new AtomicLong(0L);
    private final ConcurrentMap<Integer, Integer> expectedRegionId2DataNodeIdMap = new ConcurrentHashMap<Integer, Integer>();
    private final ConcurrentMap<String, Combiner> combineId2Combiner = new ConcurrentHashMap<String, Combiner>();

    public PipeCombineHandler(String pipeName, long creationTime, Function<String, Operator> operatorConstructor) {
        this.pipeName = pipeName;
        this.creationTime = creationTime;
        this.operatorConstructor = operatorConstructor;
        this.fetchAndUpdateExpectedRegionId2DataNodeIdMap();
    }

    public synchronized TSStatus combine(int regionId, String combineId, State state) {
        return this.combineId2Combiner.computeIfAbsent(combineId, id -> new Combiner(this.operatorConstructor.apply(combineId), this.expectedRegionId2DataNodeIdMap)).combine(regionId, state);
    }

    public synchronized FetchCombineResultResponse fetchCombineResult(List<String> combineIdList) throws IOException {
        HashMap<String, FetchCombineResultResponse.CombineResultType> combineId2ResultType = new HashMap<String, FetchCombineResultResponse.CombineResultType>();
        for (String combineId : combineIdList) {
            Combiner combiner = (Combiner)this.combineId2Combiner.get(combineId);
            if (combiner == null || combiner.isOutdated()) {
                combineId2ResultType.put(combineId, FetchCombineResultResponse.CombineResultType.OUTDATED);
                continue;
            }
            combineId2ResultType.put(combineId, combiner.isComplete() ? FetchCombineResultResponse.CombineResultType.SUCCESS : FetchCombineResultResponse.CombineResultType.INCOMPLETE);
        }
        return FetchCombineResultResponse.toTPipeTransferResp(combineId2ResultType);
    }

    public void fetchAndUpdateExpectedRegionId2DataNodeIdMap() {
        this.updateExpectedRegionId2DataNodeIdMap(this.fetchExpectedRegionId2DataNodeIdMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, Integer> fetchExpectedRegionId2DataNodeIdMap() {
        Map<Integer, Integer> map2 = ALL_REGION_ID_2_DATANODE_ID_MAP;
        synchronized (map2) {
            if (System.currentTimeMillis() - ALL_REGION_ID_2_DATANODE_ID_MAP_LAST_UPDATE_TIME.get() > PipeConfig.getInstance().getTwoStageAggregateDataRegionInfoCacheTimeInMs()) {
                ALL_REGION_ID_2_DATANODE_ID_MAP.clear();
                try (ConfigNodeClient configNodeClient = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                    TShowRegionResp showRegionResp = configNodeClient.showRegion(new TShowRegionReq().setConsensusGroupType(TConsensusGroupType.DataRegion));
                    if (showRegionResp == null || !showRegionResp.isSetRegionInfoList()) {
                        throw new PipeException("Failed to fetch data region ids");
                    }
                    for (TRegionInfo regionInfo : showRegionResp.getRegionInfoList()) {
                        if (!RegionRoleType.Leader.getRoleType().equals(regionInfo.getRoleType())) continue;
                        ALL_REGION_ID_2_DATANODE_ID_MAP.put(regionInfo.getConsensusGroupId().getId(), regionInfo.getDataNodeId());
                    }
                }
                catch (ClientManagerException | TException e) {
                    throw new PipeException("Failed to fetch data nodes", e);
                }
                ALL_REGION_ID_2_DATANODE_ID_MAP_LAST_UPDATE_TIME.set(System.currentTimeMillis());
                LOGGER.info("Fetched data region ids {} at {}", ALL_REGION_ID_2_DATANODE_ID_MAP, (Object)ALL_REGION_ID_2_DATANODE_ID_MAP_LAST_UPDATE_TIME.get());
            }
            HashSet<Integer> pipeRelatedRegionIdSet = new HashSet<Integer>(PipeDataNodeAgent.task().getPipeTaskRegionIdSet(this.pipeName, this.creationTime));
            pipeRelatedRegionIdSet.removeIf(regionId -> !ALL_REGION_ID_2_DATANODE_ID_MAP.containsKey(regionId));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Two stage aggregate pipe (pipeName={}, creationTime={}) related region ids {}", new Object[]{this.pipeName, this.creationTime, pipeRelatedRegionIdSet});
            }
            return ALL_REGION_ID_2_DATANODE_ID_MAP.entrySet().stream().filter(entry -> pipeRelatedRegionIdSet.contains(entry.getKey())).collect(HashMap::new, (map, entry) -> map.put((Integer)entry.getKey(), (Integer)entry.getValue()), HashMap::putAll);
        }
    }

    private synchronized void updateExpectedRegionId2DataNodeIdMap(Map<Integer, Integer> newExpectedRegionId2DataNodeIdMap) {
        this.expectedRegionId2DataNodeIdMap.clear();
        this.expectedRegionId2DataNodeIdMap.putAll(newExpectedRegionId2DataNodeIdMap);
    }

    public synchronized Set<Integer> getExpectedDataNodeIdSet() {
        return new HashSet<Integer>(this.expectedRegionId2DataNodeIdMap.values());
    }

    public synchronized void cleanOutdatedCombiner() {
        this.combineId2Combiner.entrySet().removeIf(entry -> {
            if (!((Combiner)entry.getValue()).isComplete()) {
                LOGGER.info("Clean outdated incomplete combiner: pipeName={}, creationTime={}, combineId={}", new Object[]{this.pipeName, this.creationTime, entry.getKey()});
            }
            return ((Combiner)entry.getValue()).isOutdated();
        });
    }

    public synchronized void close() {
        this.combineId2Combiner.clear();
    }
}

