/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.realtime;

import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.ProgressReportEvent;
import org.apache.iotdb.db.pipe.event.common.deletion.PipeDeleteDataNodeEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.epoch.TsFileEpochManager;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.AbstractDeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class PipeRealtimeEventFactory {
    private static final TsFileEpochManager TS_FILE_EPOCH_MANAGER = new TsFileEpochManager();

    public static PipeRealtimeEvent createRealtimeEvent(Boolean isTableModel, String databaseNameFromDataRegion, TsFileResource resource, boolean isLoaded) {
        PipeTsFileInsertionEvent tsFileInsertionEvent = new PipeTsFileInsertionEvent(isTableModel, databaseNameFromDataRegion, resource, isLoaded);
        return TS_FILE_EPOCH_MANAGER.bindPipeTsFileInsertionEvent(tsFileInsertionEvent, resource);
    }

    public static PipeRealtimeEvent createRealtimeEvent(Boolean isTableModel, String databaseNameFromDataRegion, InsertNode insertNode, TsFileResource resource) {
        PipeInsertNodeTabletInsertionEvent insertionEvent = new PipeInsertNodeTabletInsertionEvent(isTableModel, databaseNameFromDataRegion, insertNode);
        return TS_FILE_EPOCH_MANAGER.bindPipeInsertNodeTabletInsertionEvent(insertionEvent, insertNode, resource);
    }

    public static PipeRealtimeEvent createRealtimeEvent(String dataRegionId, boolean shouldPrintMessage) {
        return new PipeRealtimeEvent(new PipeHeartbeatEvent(dataRegionId, shouldPrintMessage), null, null);
    }

    public static PipeRealtimeEvent createRealtimeEvent(AbstractDeleteDataNode node) {
        PipeDeleteDataNodeEvent deleteDataNodeEvent = new PipeDeleteDataNodeEvent(node, node.isGeneratedByPipe());
        return new PipeRealtimeEvent(deleteDataNodeEvent, null, null);
    }

    public static PipeRealtimeEvent createRealtimeEvent(ProgressReportEvent event) {
        return new PipeRealtimeEvent((EnrichedEvent)event, null, null);
    }

    private PipeRealtimeEventFactory() {
    }
}

