/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile.aggregator;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileInsertionPointCounter
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileInsertionPointCounter.class);
    private final TreePattern pattern;
    private final TsFileSequenceReader tsFileSequenceReader;
    final Map<IDeviceID, List<TimeseriesMetadata>> allDeviceTimeseriesMetadataMap;
    private boolean shouldParsePattern = false;
    private long count = 0L;

    public TsFileInsertionPointCounter(File tsFile, TreePattern pattern) throws IOException {
        this.pattern = pattern;
        try {
            this.tsFileSequenceReader = new TsFileSequenceReader(tsFile.getPath(), true, true);
            this.allDeviceTimeseriesMetadataMap = this.tsFileSequenceReader.getAllTimeseriesMetadata(false);
            if (Objects.isNull(this.pattern) || pattern.isRoot()) {
                this.countAllTimeseriesPoints();
            } else {
                Map<IDeviceID, Set<String>> filteredDeviceMeasurementMap = this.filterDeviceMeasurementsMapByPatternAndJudgeShouldParsePattern();
                if (this.shouldParsePattern) {
                    this.countMatchedTimeseriesPoints(filteredDeviceMeasurementMap);
                } else {
                    this.countAllTimeseriesPoints();
                }
            }
            this.tsFileSequenceReader.clearCachedDeviceMetadata();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    private Map<IDeviceID, Set<String>> filterDeviceMeasurementsMapByPatternAndJudgeShouldParsePattern() throws IOException {
        Map originalDeviceMeasurementsMap = this.tsFileSequenceReader.getDeviceMeasurementsMap();
        HashMap<IDeviceID, Set<String>> filteredDeviceMeasurementsMap = new HashMap<IDeviceID, Set<String>>();
        for (Map.Entry entry : originalDeviceMeasurementsMap.entrySet()) {
            IDeviceID deviceId = (IDeviceID)entry.getKey();
            if (this.pattern.coversDevice(deviceId)) {
                if (((List)entry.getValue()).isEmpty()) continue;
                filteredDeviceMeasurementsMap.put(deviceId, new HashSet((Collection)entry.getValue()));
                continue;
            }
            if (this.pattern.mayOverlapWithDevice(deviceId)) {
                HashSet<String> filteredMeasurements = new HashSet<String>();
                for (String measurement : (List)entry.getValue()) {
                    if (this.pattern.matchesMeasurement(deviceId, measurement)) {
                        filteredMeasurements.add(measurement);
                        continue;
                    }
                    this.shouldParsePattern = true;
                }
                if (filteredMeasurements.isEmpty()) continue;
                filteredDeviceMeasurementsMap.put(deviceId, filteredMeasurements);
                continue;
            }
            this.shouldParsePattern = true;
        }
        return filteredDeviceMeasurementsMap;
    }

    private void countMatchedTimeseriesPoints(Map<IDeviceID, Set<String>> filteredDeviceMeasurementMap) {
        for (Map.Entry<IDeviceID, List<TimeseriesMetadata>> deviceTimeseriesMetadataEntry : this.allDeviceTimeseriesMetadataMap.entrySet()) {
            IDeviceID deviceId = deviceTimeseriesMetadataEntry.getKey();
            if (!filteredDeviceMeasurementMap.containsKey(deviceId)) continue;
            List<TimeseriesMetadata> allTimeseriesMetadata = deviceTimeseriesMetadataEntry.getValue();
            Set<String> filteredMeasurements = filteredDeviceMeasurementMap.get(deviceId);
            for (TimeseriesMetadata timeseriesMetadata : allTimeseriesMetadata) {
                if (!filteredMeasurements.contains(timeseriesMetadata.getMeasurementId())) continue;
                this.count += (long)timeseriesMetadata.getStatistics().getCount();
            }
        }
    }

    private void countAllTimeseriesPoints() {
        for (List<TimeseriesMetadata> allTimeseriesMetadata : this.allDeviceTimeseriesMetadataMap.values()) {
            for (TimeseriesMetadata timeseriesMetadata : allTimeseriesMetadata) {
                this.count += (long)timeseriesMetadata.getStatistics().getCount();
            }
        }
    }

    public long count() {
        return this.count;
    }

    @Override
    public void close() {
        try {
            if (this.tsFileSequenceReader != null) {
                this.tsFileSequenceReader.close();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to close TsFileSequenceReader", (Throwable)e);
        }
    }
}

