/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.pipe.service;

import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.utils.KillPoint.DataNodeKillPoints;
import org.apache.iotdb.commons.utils.KillPoint.IoTConsensusInactivatePeerKillPoints;
import org.apache.iotdb.commons.utils.KillPoint.KillPoint;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.config.PipeConsensusConfig;
import org.apache.iotdb.consensus.exception.ConsensusGroupModifyPeerException;
import org.apache.iotdb.consensus.pipe.PipeConsensus;
import org.apache.iotdb.consensus.pipe.PipeConsensusServerImpl;
import org.apache.iotdb.consensus.pipe.thrift.PipeConsensusIService;
import org.apache.iotdb.consensus.pipe.thrift.TCheckConsensusPipeCompletedReq;
import org.apache.iotdb.consensus.pipe.thrift.TCheckConsensusPipeCompletedResp;
import org.apache.iotdb.consensus.pipe.thrift.TNotifyPeerToCreateConsensusPipeReq;
import org.apache.iotdb.consensus.pipe.thrift.TNotifyPeerToCreateConsensusPipeResp;
import org.apache.iotdb.consensus.pipe.thrift.TNotifyPeerToDropConsensusPipeReq;
import org.apache.iotdb.consensus.pipe.thrift.TNotifyPeerToDropConsensusPipeResp;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusBatchTransferReq;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusBatchTransferResp;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferReq;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferResp;
import org.apache.iotdb.consensus.pipe.thrift.TSetActiveReq;
import org.apache.iotdb.consensus.pipe.thrift.TSetActiveResp;
import org.apache.iotdb.consensus.pipe.thrift.TWaitReleaseAllRegionRelatedResourceReq;
import org.apache.iotdb.consensus.pipe.thrift.TWaitReleaseAllRegionRelatedResourceResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConsensusRPCServiceProcessor
implements PipeConsensusIService.Iface {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConsensusRPCServiceProcessor.class);
    private final PipeConsensus pipeConsensus;
    private final PipeConsensusConfig.Pipe config;

    public PipeConsensusRPCServiceProcessor(PipeConsensus pipeConsensus, PipeConsensusConfig.Pipe config) {
        this.pipeConsensus = pipeConsensus;
        this.config = config;
    }

    public TPipeConsensusTransferResp pipeConsensusTransfer(TPipeConsensusTransferReq req) {
        return this.config.getConsensusPipeReceiver().receive(req);
    }

    public TPipeConsensusBatchTransferResp pipeConsensusBatchTransfer(TPipeConsensusBatchTransferReq req) throws TException {
        return new TPipeConsensusBatchTransferResp();
    }

    public TSetActiveResp setActive(TSetActiveReq req) throws TException {
        ConsensusGroupId groupId;
        PipeConsensusServerImpl impl;
        if (req.isForDeletionPurpose && !req.isActive) {
            KillPoint.setKillPoint((Enum)IoTConsensusInactivatePeerKillPoints.BEFORE_INACTIVATE);
        }
        if ((impl = this.pipeConsensus.getImpl(groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.consensusGroupId))) == null) {
            String message = String.format("unexpected consensusGroupId %s for set active request %s", groupId, req);
            LOGGER.error(message);
            TSStatus status = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            status.setMessage(message);
            return new TSetActiveResp(status);
        }
        impl.setActive(req.isActive);
        if (req.isActive) {
            KillPoint.setKillPoint((Enum)DataNodeKillPoints.DESTINATION_ADD_PEER_DONE);
        }
        if (req.isForDeletionPurpose && !req.isActive) {
            KillPoint.setKillPoint((Enum)IoTConsensusInactivatePeerKillPoints.AFTER_INACTIVATE);
        }
        return new TSetActiveResp(RpcUtils.SUCCESS_STATUS);
    }

    public TNotifyPeerToCreateConsensusPipeResp notifyPeerToCreateConsensusPipe(TNotifyPeerToCreateConsensusPipeReq req) throws TException {
        TSStatus responseStatus;
        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.targetPeerConsensusGroupId);
        PipeConsensusServerImpl impl = this.pipeConsensus.getImpl(groupId);
        if (impl == null) {
            String message = String.format("unexpected consensusGroupId %s for create consensus pipe request %s", groupId, req);
            LOGGER.error(message);
            TSStatus status = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            status.setMessage(message);
            return new TNotifyPeerToCreateConsensusPipeResp(status);
        }
        try {
            impl.createConsensusPipeToTargetPeer(new Peer(ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.targetPeerConsensusGroupId), req.targetPeerNodeId, req.targetPeerEndPoint), false);
            responseStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (ConsensusGroupModifyPeerException e) {
            responseStatus = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            responseStatus.setMessage(e.getMessage());
            LOGGER.warn("Failed to create consensus pipe to target peer with req {}", (Object)req, (Object)e);
        }
        return new TNotifyPeerToCreateConsensusPipeResp(responseStatus);
    }

    public TNotifyPeerToDropConsensusPipeResp notifyPeerToDropConsensusPipe(TNotifyPeerToDropConsensusPipeReq req) throws TException {
        TSStatus responseStatus;
        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.targetPeerConsensusGroupId);
        PipeConsensusServerImpl impl = this.pipeConsensus.getImpl(groupId);
        if (impl == null) {
            String message = String.format("unexpected consensusGroupId %s for drop consensus pipe request %s", groupId, req);
            LOGGER.error(message);
            TSStatus status = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            status.setMessage(message);
            return new TNotifyPeerToDropConsensusPipeResp(status);
        }
        try {
            impl.dropConsensusPipeToTargetPeer(new Peer(ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.targetPeerConsensusGroupId), req.targetPeerNodeId, req.targetPeerEndPoint));
            responseStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (ConsensusGroupModifyPeerException e) {
            responseStatus = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            responseStatus.setMessage(e.getMessage());
            LOGGER.warn("Failed to drop consensus pipe to target peer with req {}", (Object)req, (Object)e);
        }
        return new TNotifyPeerToDropConsensusPipeResp(responseStatus);
    }

    public TCheckConsensusPipeCompletedResp checkConsensusPipeCompleted(TCheckConsensusPipeCompletedReq req) throws TException {
        TSStatus responseStatus;
        boolean isCompleted;
        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.consensusGroupId);
        PipeConsensusServerImpl impl = this.pipeConsensus.getImpl(groupId);
        if (impl == null) {
            String message = String.format("unexpected consensusGroupId %s for check transfer completed request %s", groupId, req);
            LOGGER.error(message);
            TSStatus status = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            status.setMessage(message);
            return new TCheckConsensusPipeCompletedResp(status, true);
        }
        try {
            isCompleted = impl.isConsensusPipesTransmissionCompleted(req.consensusPipeNames, req.refreshCachedProgressIndex);
            responseStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (Exception e) {
            responseStatus = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            responseStatus.setMessage(e.getMessage());
            isCompleted = true;
            LOGGER.warn("Failed to check consensus pipe completed with req {}, set is completed to {}", new Object[]{req, true, e});
        }
        return new TCheckConsensusPipeCompletedResp(responseStatus, isCompleted);
    }

    public TWaitReleaseAllRegionRelatedResourceResp waitReleaseAllRegionRelatedResource(TWaitReleaseAllRegionRelatedResourceReq req) {
        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getConsensusGroupId());
        PipeConsensusServerImpl impl = this.pipeConsensus.getImpl(groupId);
        if (impl == null) {
            String message = String.format("unexpected consensusGroupId %s for TWaitReleaseAllRegionRelatedResourceRes request", groupId);
            LOGGER.error(message);
            return new TWaitReleaseAllRegionRelatedResourceResp(true);
        }
        return new TWaitReleaseAllRegionRelatedResourceResp(impl.hasReleaseAllRegionRelatedResource(groupId));
    }

    public void handleExit() {
    }
}

