/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.io.IOException;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.MappableRowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;

public class UDTFConstPi
implements UDTF {
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        configurations.setAccessStrategy((AccessStrategy)new MappableRowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
    }

    public void transform(Row row, PointCollector collector) throws Exception {
        collector.putDouble(row.getTime(), Math.PI);
    }

    public Object transform(Row row) throws IOException {
        return Math.PI;
    }

    public void transform(Column[] columns, ColumnBuilder builder) throws Exception {
        int rowCount = columns[0].getPositionCount();
        for (int i = 0; i < rowCount; ++i) {
            boolean hasWritten = false;
            for (int j = 0; j < columns.length - 1; ++j) {
                if (columns[j].isNull(i)) continue;
                builder.writeDouble(Math.PI);
                hasWritten = true;
                break;
            }
            if (hasWritten) continue;
            builder.appendNull();
        }
    }
}

