/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.filters;

import java.util.Iterator;
import java.util.Optional;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.nodes.DefaultAttributeFilter;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilter;
import org.eclipse.milo.opcua.stack.core.AttributeId;

public abstract class AttributeFilterContext {
    private volatile boolean observable = false;
    private final UaNode node;
    private final Session session;

    private AttributeFilterContext(Session session, UaNode node) {
        this.session = session;
        this.node = node;
    }

    public UaNode getNode() {
        return this.node;
    }

    public Optional<Session> getSession() {
        return Optional.ofNullable(this.session);
    }

    public void setObservable(boolean observable) {
        this.observable = observable;
    }

    public boolean isObservable() {
        return this.observable;
    }

    public static final class SetAttributeContext
    extends AttributeFilterContext {
        private final Iterator<AttributeFilter> filterIterator;

        SetAttributeContext(Session session, UaNode node, Iterator<AttributeFilter> filterIterator) {
            super(session, node);
            this.filterIterator = filterIterator;
        }

        public void setAttribute(AttributeId attributeId, Object value) {
            DefaultAttributeFilter next = this.filterIterator.hasNext() ? this.filterIterator.next() : AttributeFilter.DEFAULT_INSTANCE;
            next.setAttribute(this, attributeId, value);
        }
    }

    public static final class GetAttributeContext
    extends AttributeFilterContext {
        private final Iterator<AttributeFilter> filterIterator;

        GetAttributeContext(Session session, UaNode node, Iterator<AttributeFilter> filterIterator) {
            super(session, node);
            this.filterIterator = filterIterator;
        }

        public Object getAttribute(AttributeId attributeId) {
            DefaultAttributeFilter next = this.filterIterator.hasNext() ? this.filterIterator.next() : AttributeFilter.DEFAULT_INSTANCE;
            return next.getAttribute(this, attributeId);
        }
    }
}

