/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.identity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.List;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.identity.IdentityValidator;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeValidator<T>
implements IdentityValidator<T> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ImmutableList<IdentityValidator<T>> validators;

    public CompositeValidator(IdentityValidator<T> ... validators) {
        this.validators = ImmutableList.copyOf((Object[])validators);
    }

    public CompositeValidator(List<IdentityValidator<T>> validators) {
        this.validators = ImmutableList.copyOf(validators);
    }

    @Override
    public T validateIdentityToken(Session session, UserIdentityToken token, UserTokenPolicy tokenPolicy, SignatureData tokenSignature) throws UaException {
        UnmodifiableIterator iterator = this.validators.iterator();
        while (iterator.hasNext()) {
            IdentityValidator validator = (IdentityValidator)iterator.next();
            try {
                return validator.validateIdentityToken(session, token, tokenPolicy, tokenSignature);
            }
            catch (Exception e) {
                if (!iterator.hasNext()) {
                    throw e;
                }
                this.logger.debug("IdentityValidator={} failed, trying next...", (Object)validator.toString());
            }
        }
        throw new UaException(0x80200000L);
    }
}

