/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class RegisterNodesResponse
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=561");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=563");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=562");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15196");
    private final ResponseHeader responseHeader;
    private final NodeId[] registeredNodeIds;

    public RegisterNodesResponse(ResponseHeader responseHeader, NodeId[] registeredNodeIds) {
        this.responseHeader = responseHeader;
        this.registeredNodeIds = registeredNodeIds;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public NodeId[] getRegisteredNodeIds() {
        return this.registeredNodeIds;
    }

    protected RegisterNodesResponse(RegisterNodesResponseBuilder<?, ?> b) {
        super(b);
        this.responseHeader = ((RegisterNodesResponseBuilder)b).responseHeader;
        this.registeredNodeIds = ((RegisterNodesResponseBuilder)b).registeredNodeIds;
    }

    public static RegisterNodesResponseBuilder<?, ?> builder() {
        return new RegisterNodesResponseBuilderImpl();
    }

    public RegisterNodesResponseBuilder<?, ?> toBuilder() {
        return new RegisterNodesResponseBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisterNodesResponse)) {
            return false;
        }
        RegisterNodesResponse other = (RegisterNodesResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseHeader this$responseHeader = this.getResponseHeader();
        ResponseHeader other$responseHeader = other.getResponseHeader();
        if (this$responseHeader == null ? other$responseHeader != null : !((Object)this$responseHeader).equals(other$responseHeader)) {
            return false;
        }
        return Arrays.deepEquals(this.getRegisteredNodeIds(), other.getRegisteredNodeIds());
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegisterNodesResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseHeader $responseHeader = this.getResponseHeader();
        result = result * 59 + ($responseHeader == null ? 43 : ((Object)$responseHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getRegisteredNodeIds());
        return result;
    }

    @Override
    public String toString() {
        return "RegisterNodesResponse(responseHeader=" + this.getResponseHeader() + ", registeredNodeIds=" + Arrays.deepToString(this.getRegisteredNodeIds()) + ")";
    }

    private static final class RegisterNodesResponseBuilderImpl
    extends RegisterNodesResponseBuilder<RegisterNodesResponse, RegisterNodesResponseBuilderImpl> {
        private RegisterNodesResponseBuilderImpl() {
        }

        @Override
        protected RegisterNodesResponseBuilderImpl self() {
            return this;
        }

        @Override
        public RegisterNodesResponse build() {
            return new RegisterNodesResponse(this);
        }
    }

    public static abstract class RegisterNodesResponseBuilder<C extends RegisterNodesResponse, B extends RegisterNodesResponseBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ResponseHeader responseHeader;
        private NodeId[] registeredNodeIds;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RegisterNodesResponseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(RegisterNodesResponse instance, RegisterNodesResponseBuilder<?, ?> b) {
            b.responseHeader(instance.responseHeader);
            b.registeredNodeIds(instance.registeredNodeIds);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B responseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return (B)this.self();
        }

        public B registeredNodeIds(NodeId[] registeredNodeIds) {
            this.registeredNodeIds = registeredNodeIds;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "RegisterNodesResponse.RegisterNodesResponseBuilder(super=" + super.toString() + ", responseHeader=" + this.responseHeader + ", registeredNodeIds=" + Arrays.deepToString(this.registeredNodeIds) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<RegisterNodesResponse> {
        @Override
        public Class<RegisterNodesResponse> getType() {
            return RegisterNodesResponse.class;
        }

        @Override
        public RegisterNodesResponse decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            NodeId[] registeredNodeIds = decoder.readNodeIdArray("RegisteredNodeIds");
            return new RegisterNodesResponse(responseHeader, registeredNodeIds);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, RegisterNodesResponse value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeNodeIdArray("RegisteredNodeIds", value.getRegisteredNodeIds());
        }
    }
}

