/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemModifyRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ModifyMonitoredItemsRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=761");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=763");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=762");
    private final RequestHeader requestHeader;
    private final UInteger subscriptionId;
    private final TimestampsToReturn timestampsToReturn;
    private final MonitoredItemModifyRequest[] itemsToModify;

    public ModifyMonitoredItemsRequest(RequestHeader requestHeader, UInteger subscriptionId, TimestampsToReturn timestampsToReturn, MonitoredItemModifyRequest[] itemsToModify) {
        this.requestHeader = requestHeader;
        this.subscriptionId = subscriptionId;
        this.timestampsToReturn = timestampsToReturn;
        this.itemsToModify = itemsToModify;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public UInteger getSubscriptionId() {
        return this.subscriptionId;
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.timestampsToReturn;
    }

    public MonitoredItemModifyRequest[] getItemsToModify() {
        return this.itemsToModify;
    }

    protected ModifyMonitoredItemsRequest(ModifyMonitoredItemsRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((ModifyMonitoredItemsRequestBuilder)b).requestHeader;
        this.subscriptionId = ((ModifyMonitoredItemsRequestBuilder)b).subscriptionId;
        this.timestampsToReturn = ((ModifyMonitoredItemsRequestBuilder)b).timestampsToReturn;
        this.itemsToModify = ((ModifyMonitoredItemsRequestBuilder)b).itemsToModify;
    }

    public static ModifyMonitoredItemsRequestBuilder<?, ?> builder() {
        return new ModifyMonitoredItemsRequestBuilderImpl();
    }

    public ModifyMonitoredItemsRequestBuilder<?, ?> toBuilder() {
        return new ModifyMonitoredItemsRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModifyMonitoredItemsRequest)) {
            return false;
        }
        ModifyMonitoredItemsRequest other = (ModifyMonitoredItemsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        UInteger this$subscriptionId = this.getSubscriptionId();
        UInteger other$subscriptionId = other.getSubscriptionId();
        if (this$subscriptionId == null ? other$subscriptionId != null : !((Object)this$subscriptionId).equals(other$subscriptionId)) {
            return false;
        }
        TimestampsToReturn this$timestampsToReturn = this.getTimestampsToReturn();
        TimestampsToReturn other$timestampsToReturn = other.getTimestampsToReturn();
        if (this$timestampsToReturn == null ? other$timestampsToReturn != null : !this$timestampsToReturn.equals(other$timestampsToReturn)) {
            return false;
        }
        return Arrays.deepEquals(this.getItemsToModify(), other.getItemsToModify());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModifyMonitoredItemsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        UInteger $subscriptionId = this.getSubscriptionId();
        result = result * 59 + ($subscriptionId == null ? 43 : ((Object)$subscriptionId).hashCode());
        TimestampsToReturn $timestampsToReturn = this.getTimestampsToReturn();
        result = result * 59 + ($timestampsToReturn == null ? 43 : $timestampsToReturn.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getItemsToModify());
        return result;
    }

    @Override
    public String toString() {
        return "ModifyMonitoredItemsRequest(requestHeader=" + this.getRequestHeader() + ", subscriptionId=" + this.getSubscriptionId() + ", timestampsToReturn=" + this.getTimestampsToReturn() + ", itemsToModify=" + Arrays.deepToString(this.getItemsToModify()) + ")";
    }

    private static final class ModifyMonitoredItemsRequestBuilderImpl
    extends ModifyMonitoredItemsRequestBuilder<ModifyMonitoredItemsRequest, ModifyMonitoredItemsRequestBuilderImpl> {
        private ModifyMonitoredItemsRequestBuilderImpl() {
        }

        @Override
        protected ModifyMonitoredItemsRequestBuilderImpl self() {
            return this;
        }

        @Override
        public ModifyMonitoredItemsRequest build() {
            return new ModifyMonitoredItemsRequest(this);
        }
    }

    public static abstract class ModifyMonitoredItemsRequestBuilder<C extends ModifyMonitoredItemsRequest, B extends ModifyMonitoredItemsRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private UInteger subscriptionId;
        private TimestampsToReturn timestampsToReturn;
        private MonitoredItemModifyRequest[] itemsToModify;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ModifyMonitoredItemsRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ModifyMonitoredItemsRequest instance, ModifyMonitoredItemsRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.subscriptionId(instance.subscriptionId);
            b.timestampsToReturn(instance.timestampsToReturn);
            b.itemsToModify(instance.itemsToModify);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B subscriptionId(UInteger subscriptionId) {
            this.subscriptionId = subscriptionId;
            return (B)this.self();
        }

        public B timestampsToReturn(TimestampsToReturn timestampsToReturn) {
            this.timestampsToReturn = timestampsToReturn;
            return (B)this.self();
        }

        public B itemsToModify(MonitoredItemModifyRequest[] itemsToModify) {
            this.itemsToModify = itemsToModify;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ModifyMonitoredItemsRequest.ModifyMonitoredItemsRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", subscriptionId=" + this.subscriptionId + ", timestampsToReturn=" + this.timestampsToReturn + ", itemsToModify=" + Arrays.deepToString(this.itemsToModify) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ModifyMonitoredItemsRequest> {
        @Override
        public Class<ModifyMonitoredItemsRequest> getType() {
            return ModifyMonitoredItemsRequest.class;
        }

        @Override
        public ModifyMonitoredItemsRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            UInteger subscriptionId = decoder.readUInt32("SubscriptionId");
            TimestampsToReturn timestampsToReturn = decoder.readEnum("TimestampsToReturn", TimestampsToReturn.class);
            MonitoredItemModifyRequest[] itemsToModify = (MonitoredItemModifyRequest[])decoder.readStructArray("ItemsToModify", MonitoredItemModifyRequest.TYPE_ID);
            return new ModifyMonitoredItemsRequest(requestHeader, subscriptionId, timestampsToReturn, itemsToModify);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ModifyMonitoredItemsRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeUInt32("SubscriptionId", value.getSubscriptionId());
            encoder.writeEnum("TimestampsToReturn", value.getTimestampsToReturn());
            encoder.writeStructArray("ItemsToModify", (Object[])value.getItemsToModify(), MonitoredItemModifyRequest.TYPE_ID);
        }
    }
}

