/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaXmlStreamDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaXmlStreamEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaXmlDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.DataTypeEncoding;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.xml.sax.SAXException;

public class OpcUaDefaultXmlEncoding
implements DataTypeEncoding {
    public static final QualifiedName ENCODING_NAME = new QualifiedName(0, "Default XML");

    public static OpcUaDefaultXmlEncoding getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public QualifiedName getName() {
        return ENCODING_NAME;
    }

    @Override
    public ExtensionObject.BodyType getBodyType() {
        return ExtensionObject.BodyType.XmlElement;
    }

    @Override
    public Object encode(SerializationContext context, Object struct, NodeId encodingId) {
        try {
            OpcUaXmlDataTypeCodec codec = (OpcUaXmlDataTypeCodec)context.getDataTypeManager().getCodec(encodingId);
            if (codec == null) {
                throw new UaSerializationException(0x80060000L, "no codec registered for encodingId=" + encodingId);
            }
            OpcUaXmlStreamEncoder writer = new OpcUaXmlStreamEncoder(context);
            writer.writeStruct(null, struct, codec);
            return new XmlElement(writer.getDocumentXml());
        }
        catch (ClassCastException e) {
            throw new UaSerializationException(0x80060000L, (Throwable)e);
        }
    }

    @Override
    public Object decode(SerializationContext context, Object body, NodeId encodingId) {
        try {
            OpcUaXmlDataTypeCodec codec = (OpcUaXmlDataTypeCodec)context.getDataTypeManager().getCodec(encodingId);
            if (codec == null) {
                throw new UaSerializationException(0x80070000L, "no codec registered for encodingId=" + encodingId);
            }
            XmlElement xmlBody = (XmlElement)body;
            String xml = xmlBody.getFragmentOrEmpty();
            OpcUaXmlStreamDecoder reader = new OpcUaXmlStreamDecoder(context);
            reader.setInput(new ByteArrayInputStream(xml.getBytes(Charsets.UTF_8)));
            return reader.readStruct(null, codec);
        }
        catch (IOException | SAXException e) {
            throw new UaSerializationException(0x80070000L, (Throwable)e);
        }
    }

    private static class InstanceHolder {
        private static final OpcUaDefaultXmlEncoding INSTANCE = new OpcUaDefaultXmlEncoding();

        private InstanceHolder() {
        }
    }
}

