/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ThriftClient {
    public static final Logger logger = LoggerFactory.getLogger(ThriftClient.class);

    public void invalidate();

    public void invalidateAll();

    public boolean printLogWhenEncounterException();

    public static void resolveException(Throwable t, ThriftClient o) {
        Throwable rootCause;
        Throwable cur;
        Throwable origin = t;
        if (t instanceof InvocationTargetException) {
            origin = ((InvocationTargetException)t).getTargetException();
        }
        if ((cur = origin) instanceof TException) {
            int level = 0;
            while (cur != null) {
                logger.debug("level-{} Exception class {}, message {}", new Object[]{level, cur.getClass().getName(), cur.getMessage()});
                cur = cur.getCause();
                ++level;
            }
            o.invalidate();
        }
        if ((rootCause = ExceptionUtils.getRootCause((Throwable)origin)) != null) {
            logger.debug("root cause message {}, LocalizedMessage {}, ", new Object[]{rootCause.getMessage(), rootCause.getLocalizedMessage(), rootCause});
            if (ThriftClient.isConnectionBroken(rootCause)) {
                if (o.printLogWhenEncounterException()) {
                    logger.info("Broken pipe error happened in sending RPC, we need to clear all previous cached connection, error msg is {}", (Object)rootCause.toString());
                }
                o.invalidateAll();
            }
        }
    }

    public static boolean isConnectionBroken(Throwable cause) {
        return cause instanceof SocketException && cause.getMessage().contains("Broken pipe") || cause instanceof TTransportException && (ThriftClient.hasExpectedMessage(cause, "Socket is closed by peer") || ThriftClient.hasExpectedMessage(cause, "Read call frame size failed")) || cause instanceof IOException && (ThriftClient.hasExpectedMessage(cause, "Connection reset by peer") || ThriftClient.hasExpectedMessage(cause, "Broken pipe")) || cause instanceof ConnectException && ThriftClient.hasExpectedMessage(cause, "Connection refused");
    }

    public static boolean hasExpectedMessage(Throwable cause, String expectedMessage) {
        return Optional.ofNullable(cause.getMessage()).map(m -> m.contains(expectedMessage)).orElse(false);
    }
}

