/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.binaryallocator.evictor;

import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Evictor
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Evictor.class);
    private ScheduledFuture<?> scheduledFuture;
    private final String name;
    private final Duration shutdownTimeoutDuration;
    private final Duration durationBetweenEvictorRuns;
    private ScheduledExecutorService executor;

    public Evictor(String name, Duration shutdownTimeoutDuration, Duration durationBetweenEvictorRuns) {
        this.name = name;
        this.shutdownTimeoutDuration = shutdownTimeoutDuration;
        this.durationBetweenEvictorRuns = durationBetweenEvictorRuns;
    }

    void cancel() {
        this.scheduledFuture.cancel(false);
    }

    @Override
    public abstract void run();

    void setScheduledFuture(ScheduledFuture<?> scheduledFuture) {
        this.scheduledFuture = scheduledFuture;
    }

    public String toString() {
        return this.getClass().getName() + " [scheduledFuture=" + this.scheduledFuture + "]";
    }

    public void start() {
        if (null == this.executor) {
            this.executor = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor(this.name);
        }
        ScheduledFuture<?> scheduledFuture = ScheduledExecutorUtil.safelyScheduleAtFixedRate(this.executor, this, this.durationBetweenEvictorRuns.toMillis(), this.durationBetweenEvictorRuns.toMillis(), TimeUnit.MILLISECONDS);
        this.setScheduledFuture(scheduledFuture);
    }

    public void stop() {
        if (this.executor == null) {
            return;
        }
        LOGGER.info("Stopping {}", (Object)this.name);
        this.cancel();
        this.executor.shutdown();
        try {
            boolean result = this.executor.awaitTermination(this.shutdownTimeoutDuration.toMillis(), TimeUnit.MILLISECONDS);
            if (!result) {
                LOGGER.info("unable to stop evictor after {} ms", (Object)this.shutdownTimeoutDuration.toMillis());
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        this.executor = null;
    }
}

