/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePath;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class TranslateBrowsePathsToNodeIdsRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=552");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=554");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=553");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15193");
    private final RequestHeader requestHeader;
    private final BrowsePath[] browsePaths;

    public TranslateBrowsePathsToNodeIdsRequest(RequestHeader requestHeader, BrowsePath[] browsePaths) {
        this.requestHeader = requestHeader;
        this.browsePaths = browsePaths;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public BrowsePath[] getBrowsePaths() {
        return this.browsePaths;
    }

    protected TranslateBrowsePathsToNodeIdsRequest(TranslateBrowsePathsToNodeIdsRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((TranslateBrowsePathsToNodeIdsRequestBuilder)b).requestHeader;
        this.browsePaths = ((TranslateBrowsePathsToNodeIdsRequestBuilder)b).browsePaths;
    }

    public static TranslateBrowsePathsToNodeIdsRequestBuilder<?, ?> builder() {
        return new TranslateBrowsePathsToNodeIdsRequestBuilderImpl();
    }

    public TranslateBrowsePathsToNodeIdsRequestBuilder<?, ?> toBuilder() {
        return new TranslateBrowsePathsToNodeIdsRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TranslateBrowsePathsToNodeIdsRequest)) {
            return false;
        }
        TranslateBrowsePathsToNodeIdsRequest other = (TranslateBrowsePathsToNodeIdsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        return Arrays.deepEquals(this.getBrowsePaths(), other.getBrowsePaths());
    }

    protected boolean canEqual(Object other) {
        return other instanceof TranslateBrowsePathsToNodeIdsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getBrowsePaths());
        return result;
    }

    @Override
    public String toString() {
        return "TranslateBrowsePathsToNodeIdsRequest(requestHeader=" + this.getRequestHeader() + ", browsePaths=" + Arrays.deepToString(this.getBrowsePaths()) + ")";
    }

    private static final class TranslateBrowsePathsToNodeIdsRequestBuilderImpl
    extends TranslateBrowsePathsToNodeIdsRequestBuilder<TranslateBrowsePathsToNodeIdsRequest, TranslateBrowsePathsToNodeIdsRequestBuilderImpl> {
        private TranslateBrowsePathsToNodeIdsRequestBuilderImpl() {
        }

        @Override
        protected TranslateBrowsePathsToNodeIdsRequestBuilderImpl self() {
            return this;
        }

        @Override
        public TranslateBrowsePathsToNodeIdsRequest build() {
            return new TranslateBrowsePathsToNodeIdsRequest(this);
        }
    }

    public static abstract class TranslateBrowsePathsToNodeIdsRequestBuilder<C extends TranslateBrowsePathsToNodeIdsRequest, B extends TranslateBrowsePathsToNodeIdsRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private BrowsePath[] browsePaths;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TranslateBrowsePathsToNodeIdsRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(TranslateBrowsePathsToNodeIdsRequest instance, TranslateBrowsePathsToNodeIdsRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.browsePaths(instance.browsePaths);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B browsePaths(BrowsePath[] browsePaths) {
            this.browsePaths = browsePaths;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TranslateBrowsePathsToNodeIdsRequest.TranslateBrowsePathsToNodeIdsRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", browsePaths=" + Arrays.deepToString(this.browsePaths) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<TranslateBrowsePathsToNodeIdsRequest> {
        @Override
        public Class<TranslateBrowsePathsToNodeIdsRequest> getType() {
            return TranslateBrowsePathsToNodeIdsRequest.class;
        }

        @Override
        public TranslateBrowsePathsToNodeIdsRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            BrowsePath[] browsePaths = (BrowsePath[])decoder.readStructArray("BrowsePaths", BrowsePath.TYPE_ID);
            return new TranslateBrowsePathsToNodeIdsRequest(requestHeader, browsePaths);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, TranslateBrowsePathsToNodeIdsRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeStructArray("BrowsePaths", (Object[])value.getBrowsePaths(), BrowsePath.TYPE_ID);
        }
    }
}

