/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class BuildInfo
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=338");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=339");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=340");
    private final String productUri;
    private final String manufacturerName;
    private final String productName;
    private final String softwareVersion;
    private final String buildNumber;
    private final DateTime buildDate;

    public BuildInfo(String productUri, String manufacturerName, String productName, String softwareVersion, String buildNumber, DateTime buildDate) {
        this.productUri = productUri;
        this.manufacturerName = manufacturerName;
        this.productName = productName;
        this.softwareVersion = softwareVersion;
        this.buildNumber = buildNumber;
        this.buildDate = buildDate;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public String getProductUri() {
        return this.productUri;
    }

    public String getManufacturerName() {
        return this.manufacturerName;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public DateTime getBuildDate() {
        return this.buildDate;
    }

    protected BuildInfo(BuildInfoBuilder<?, ?> b) {
        super(b);
        this.productUri = ((BuildInfoBuilder)b).productUri;
        this.manufacturerName = ((BuildInfoBuilder)b).manufacturerName;
        this.productName = ((BuildInfoBuilder)b).productName;
        this.softwareVersion = ((BuildInfoBuilder)b).softwareVersion;
        this.buildNumber = ((BuildInfoBuilder)b).buildNumber;
        this.buildDate = ((BuildInfoBuilder)b).buildDate;
    }

    public static BuildInfoBuilder<?, ?> builder() {
        return new BuildInfoBuilderImpl();
    }

    public BuildInfoBuilder<?, ?> toBuilder() {
        return new BuildInfoBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildInfo)) {
            return false;
        }
        BuildInfo other = (BuildInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$productUri = this.getProductUri();
        String other$productUri = other.getProductUri();
        if (this$productUri == null ? other$productUri != null : !this$productUri.equals(other$productUri)) {
            return false;
        }
        String this$manufacturerName = this.getManufacturerName();
        String other$manufacturerName = other.getManufacturerName();
        if (this$manufacturerName == null ? other$manufacturerName != null : !this$manufacturerName.equals(other$manufacturerName)) {
            return false;
        }
        String this$productName = this.getProductName();
        String other$productName = other.getProductName();
        if (this$productName == null ? other$productName != null : !this$productName.equals(other$productName)) {
            return false;
        }
        String this$softwareVersion = this.getSoftwareVersion();
        String other$softwareVersion = other.getSoftwareVersion();
        if (this$softwareVersion == null ? other$softwareVersion != null : !this$softwareVersion.equals(other$softwareVersion)) {
            return false;
        }
        String this$buildNumber = this.getBuildNumber();
        String other$buildNumber = other.getBuildNumber();
        if (this$buildNumber == null ? other$buildNumber != null : !this$buildNumber.equals(other$buildNumber)) {
            return false;
        }
        DateTime this$buildDate = this.getBuildDate();
        DateTime other$buildDate = other.getBuildDate();
        return !(this$buildDate == null ? other$buildDate != null : !((Object)this$buildDate).equals(other$buildDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $productUri = this.getProductUri();
        result = result * 59 + ($productUri == null ? 43 : $productUri.hashCode());
        String $manufacturerName = this.getManufacturerName();
        result = result * 59 + ($manufacturerName == null ? 43 : $manufacturerName.hashCode());
        String $productName = this.getProductName();
        result = result * 59 + ($productName == null ? 43 : $productName.hashCode());
        String $softwareVersion = this.getSoftwareVersion();
        result = result * 59 + ($softwareVersion == null ? 43 : $softwareVersion.hashCode());
        String $buildNumber = this.getBuildNumber();
        result = result * 59 + ($buildNumber == null ? 43 : $buildNumber.hashCode());
        DateTime $buildDate = this.getBuildDate();
        result = result * 59 + ($buildDate == null ? 43 : ((Object)$buildDate).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "BuildInfo(productUri=" + this.getProductUri() + ", manufacturerName=" + this.getManufacturerName() + ", productName=" + this.getProductName() + ", softwareVersion=" + this.getSoftwareVersion() + ", buildNumber=" + this.getBuildNumber() + ", buildDate=" + this.getBuildDate() + ")";
    }

    private static final class BuildInfoBuilderImpl
    extends BuildInfoBuilder<BuildInfo, BuildInfoBuilderImpl> {
        private BuildInfoBuilderImpl() {
        }

        @Override
        protected BuildInfoBuilderImpl self() {
            return this;
        }

        @Override
        public BuildInfo build() {
            return new BuildInfo(this);
        }
    }

    public static abstract class BuildInfoBuilder<C extends BuildInfo, B extends BuildInfoBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private String productUri;
        private String manufacturerName;
        private String productName;
        private String softwareVersion;
        private String buildNumber;
        private DateTime buildDate;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BuildInfoBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(BuildInfo instance, BuildInfoBuilder<?, ?> b) {
            b.productUri(instance.productUri);
            b.manufacturerName(instance.manufacturerName);
            b.productName(instance.productName);
            b.softwareVersion(instance.softwareVersion);
            b.buildNumber(instance.buildNumber);
            b.buildDate(instance.buildDate);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B productUri(String productUri) {
            this.productUri = productUri;
            return (B)this.self();
        }

        public B manufacturerName(String manufacturerName) {
            this.manufacturerName = manufacturerName;
            return (B)this.self();
        }

        public B productName(String productName) {
            this.productName = productName;
            return (B)this.self();
        }

        public B softwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
            return (B)this.self();
        }

        public B buildNumber(String buildNumber) {
            this.buildNumber = buildNumber;
            return (B)this.self();
        }

        public B buildDate(DateTime buildDate) {
            this.buildDate = buildDate;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "BuildInfo.BuildInfoBuilder(super=" + super.toString() + ", productUri=" + this.productUri + ", manufacturerName=" + this.manufacturerName + ", productName=" + this.productName + ", softwareVersion=" + this.softwareVersion + ", buildNumber=" + this.buildNumber + ", buildDate=" + this.buildDate + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<BuildInfo> {
        @Override
        public Class<BuildInfo> getType() {
            return BuildInfo.class;
        }

        @Override
        public BuildInfo decode(SerializationContext context, UaDecoder decoder) {
            String productUri = decoder.readString("ProductUri");
            String manufacturerName = decoder.readString("ManufacturerName");
            String productName = decoder.readString("ProductName");
            String softwareVersion = decoder.readString("SoftwareVersion");
            String buildNumber = decoder.readString("BuildNumber");
            DateTime buildDate = decoder.readDateTime("BuildDate");
            return new BuildInfo(productUri, manufacturerName, productName, softwareVersion, buildNumber, buildDate);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, BuildInfo value) {
            encoder.writeString("ProductUri", value.getProductUri());
            encoder.writeString("ManufacturerName", value.getManufacturerName());
            encoder.writeString("ProductName", value.getProductName());
            encoder.writeString("SoftwareVersion", value.getSoftwareVersion());
            encoder.writeString("BuildNumber", value.getBuildNumber());
            encoder.writeDateTime("BuildDate", value.getBuildDate());
        }
    }
}

