/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.jvm;

import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.metrics.utils.SystemMetric;
import org.apache.iotdb.metrics.utils.SystemTag;

public class JvmCompileMetrics
implements IMetricSet {
    @Override
    public void bindTo(AbstractMetricService metricService) {
        CompilationMXBean compilationBean = ManagementFactory.getCompilationMXBean();
        if (compilationBean != null && compilationBean.isCompilationTimeMonitoringSupported()) {
            metricService.createAutoGauge(SystemMetric.JVM_COMPILATION_TIME_MS.toString(), MetricLevel.IMPORTANT, compilationBean, CompilationMXBean::getTotalCompilationTime, SystemTag.COMPILER.toString(), compilationBean.getName());
        }
    }

    @Override
    public void unbindFrom(AbstractMetricService metricService) {
        CompilationMXBean compilationBean = ManagementFactory.getCompilationMXBean();
        if (compilationBean != null && compilationBean.isCompilationTimeMonitoringSupported()) {
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.JVM_COMPILATION_TIME_MS.toString(), SystemTag.COMPILER.toString(), compilationBean.getName());
        }
    }
}

