/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis.metrics;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class RefCountingMap<K, V> {
    private final ConcurrentMap<K, Payload<V>> map = new ConcurrentHashMap<K, Payload<V>>();

    RefCountingMap() {
    }

    V put(K k, Supplier<V> supplier) {
        return this.map.compute(k, (k1, old) -> old != null ? old : new Payload(supplier.get())).increment();
    }

    static <V> V get(Payload<V> p) {
        return p == null ? null : (V)p.get();
    }

    V get(K k) {
        return RefCountingMap.get((Payload)this.map.get(k));
    }

    V remove(K k) {
        return RefCountingMap.get(this.map.computeIfPresent(k, (k1, v) -> v.decrement()));
    }

    void clear() {
        this.map.clear();
    }

    Set<K> keySet() {
        return this.map.keySet();
    }

    Collection<V> values() {
        return this.map.values().stream().map(Payload::get).collect(Collectors.toList());
    }

    int size() {
        return this.map.size();
    }

    private static class Payload<V> {
        private final V value;
        private final AtomicInteger refCount = new AtomicInteger();

        Payload(V v) {
            this.value = v;
        }

        V get() {
            return this.value;
        }

        V increment() {
            return this.refCount.incrementAndGet() > 0 ? (V)this.value : null;
        }

        Payload<V> decrement() {
            return this.refCount.decrementAndGet() > 0 ? this : null;
        }
    }
}

