/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.udf.api.customizer.strategy;

import java.time.ZoneId;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;

public class SlidingTimeWindowAccessStrategy
implements AccessStrategy {
    private final long timeInterval;
    private final long slidingStep;
    private final long displayWindowBegin;
    private final long displayWindowEnd;
    private ZoneId zoneId;

    @Deprecated
    public SlidingTimeWindowAccessStrategy(String timeIntervalString, String slidingStepString, String displayWindowBeginString, String displayWindowEndString) {
        throw new UnsupportedOperationException("The method is deprecated since v0.14.");
    }

    @Deprecated
    public SlidingTimeWindowAccessStrategy(String timeIntervalString, String slidingStepString) {
        throw new UnsupportedOperationException("The method is deprecated since v0.14.");
    }

    public SlidingTimeWindowAccessStrategy(String timeIntervalString) {
        throw new UnsupportedOperationException("The method is deprecated since v0.14.");
    }

    public SlidingTimeWindowAccessStrategy(long timeInterval, long slidingStep, long displayWindowBegin, long displayWindowEnd) {
        this.timeInterval = timeInterval;
        this.slidingStep = slidingStep;
        this.displayWindowBegin = displayWindowBegin;
        this.displayWindowEnd = displayWindowEnd;
    }

    public SlidingTimeWindowAccessStrategy(long timeInterval, long slidingStep) {
        this.timeInterval = timeInterval;
        this.slidingStep = slidingStep;
        this.displayWindowBegin = Long.MIN_VALUE;
        this.displayWindowEnd = Long.MAX_VALUE;
    }

    public SlidingTimeWindowAccessStrategy(long timeInterval) {
        this.timeInterval = timeInterval;
        this.slidingStep = timeInterval;
        this.displayWindowBegin = Long.MIN_VALUE;
        this.displayWindowEnd = Long.MAX_VALUE;
    }

    @Override
    public void check() {
        if (this.timeInterval <= 0L) {
            throw new RuntimeException(String.format("Parameter timeInterval(%d) should be positive.", this.timeInterval));
        }
        if (this.slidingStep <= 0L) {
            throw new RuntimeException(String.format("Parameter slidingStep(%d) should be positive.", this.slidingStep));
        }
        if (this.displayWindowEnd < this.displayWindowBegin) {
            throw new RuntimeException(String.format("displayWindowEnd(%d) < displayWindowBegin(%d)", this.displayWindowEnd, this.displayWindowBegin));
        }
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public long getSlidingStep() {
        return this.slidingStep;
    }

    public long getDisplayWindowBegin() {
        return this.displayWindowBegin;
    }

    public long getDisplayWindowEnd() {
        return this.displayWindowEnd;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    @Override
    public AccessStrategy.AccessStrategyType getAccessStrategyType() {
        return AccessStrategy.AccessStrategyType.SLIDING_TIME_WINDOW;
    }
}

