/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.reader;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.iotdb.commons.path.AlignedFullPath;
import org.apache.iotdb.commons.path.IFullPath;
import org.apache.iotdb.commons.path.NonAlignedFullPath;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.AlignedSeriesScanUtil;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesScanUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.reader.IDataBlockReader;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.read.common.block.TsBlock;

public class SeriesDataBlockReader
implements IDataBlockReader {
    private final SeriesScanUtil seriesScanUtil;
    private TsBlock tsBlock;
    private boolean hasCachedBatchData = false;

    public SeriesDataBlockReader(IFullPath seriesPath, Set<String> allSensors, FragmentInstanceContext context, QueryDataSource dataSource, boolean ascending) {
        SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
        scanOptionsBuilder.withAllSensors(allSensors);
        if (seriesPath instanceof AlignedFullPath) {
            this.seriesScanUtil = new AlignedSeriesScanUtil((AlignedFullPath)seriesPath, ascending ? Ordering.ASC : Ordering.DESC, scanOptionsBuilder.build(), context);
        } else if (seriesPath instanceof NonAlignedFullPath) {
            this.seriesScanUtil = new SeriesScanUtil(seriesPath, ascending ? Ordering.ASC : Ordering.DESC, scanOptionsBuilder.build(), context);
        } else {
            throw new IllegalArgumentException("Should call exact sub class!");
        }
        this.seriesScanUtil.initQueryDataSource(dataSource);
    }

    @TestOnly
    public SeriesDataBlockReader(IFullPath seriesPath, FragmentInstanceContext context, List<TsFileResource> seqFileResource, List<TsFileResource> unseqFileResource, boolean ascending) {
        SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
        if (seriesPath instanceof AlignedFullPath) {
            scanOptionsBuilder.withAllSensors(new HashSet<String>(((AlignedFullPath)seriesPath).getMeasurementList()));
            this.seriesScanUtil = new AlignedSeriesScanUtil((AlignedFullPath)seriesPath, ascending ? Ordering.ASC : Ordering.DESC, scanOptionsBuilder.build(), context);
        } else {
            scanOptionsBuilder.withAllSensors(Sets.newHashSet((Object[])new String[]{((NonAlignedFullPath)seriesPath).getMeasurement()}));
            this.seriesScanUtil = new SeriesScanUtil(seriesPath, ascending ? Ordering.ASC : Ordering.DESC, scanOptionsBuilder.build(), context);
        }
        QueryDataSource queryDataSource = new QueryDataSource(seqFileResource, unseqFileResource);
        this.seriesScanUtil.initQueryDataSource(queryDataSource);
    }

    @Override
    public boolean hasNextBatch() throws IOException {
        block5: {
            if (this.hasCachedBatchData) {
                return true;
            }
            if (this.readPageData()) {
                this.hasCachedBatchData = true;
                return true;
            }
            if (this.readChunkData()) {
                this.hasCachedBatchData = true;
                return true;
            }
            while (true) {
                Optional<Boolean> b;
                if (!(b = this.seriesScanUtil.hasNextFile()).isPresent()) {
                    continue;
                }
                if (!b.get().booleanValue()) break block5;
                if (this.readChunkData()) break;
            }
            this.hasCachedBatchData = true;
            return true;
        }
        return this.hasCachedBatchData;
    }

    @Override
    public TsBlock nextBatch() throws IOException {
        if (this.hasCachedBatchData || this.hasNextBatch()) {
            this.hasCachedBatchData = false;
            return this.tsBlock;
        }
        throw new IOException("no next block");
    }

    @Override
    public void close() throws IOException {
    }

    private boolean readChunkData() throws IOException {
        block2: {
            while (true) {
                Optional<Boolean> b;
                if (!(b = this.seriesScanUtil.hasNextChunk()).isPresent()) {
                    continue;
                }
                if (!b.get().booleanValue()) break block2;
                if (this.readPageData()) break;
            }
            return true;
        }
        return false;
    }

    private boolean readPageData() throws IOException {
        while (this.seriesScanUtil.hasNextPage()) {
            this.tsBlock = this.seriesScanUtil.nextPage();
            if (this.isEmpty(this.tsBlock)) continue;
            return true;
        }
        return false;
    }

    private boolean isEmpty(TsBlock tsBlock) {
        return tsBlock == null || tsBlock.isEmpty();
    }
}

