/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.leaf;

import org.apache.iotdb.db.queryengine.transformation.dag.column.leaf.LeafColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.read.common.type.Type;

public class ConstantColumnTransformer
extends LeafColumnTransformer {
    private final Column value;

    public ConstantColumnTransformer(Type returnType, Column value) {
        super(returnType);
        this.value = value;
    }

    @Override
    protected void evaluate() {
        this.initializeColumnCache((Column)new RunLengthEncodedColumn(this.value, this.input.getPositionCount()));
    }

    @Override
    public void evaluateWithSelection(boolean[] selection) {
        int positionCount = this.input.getPositionCount();
        ColumnBuilder builder = this.returnType.createColumnBuilder(positionCount);
        for (int i = 0; i < positionCount; ++i) {
            if (!selection[i] || this.value.isNull(0)) {
                builder.appendNull();
                continue;
            }
            builder.write(this.value, 0);
        }
        this.initializeColumnCache(builder.build());
    }
}

