/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Relation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SetOperation;

public final class Intersect
extends SetOperation {
    private final List<Relation> relations;

    public Intersect(List<Relation> relations, boolean distinct) {
        super(null, distinct);
        this.relations = ImmutableList.copyOf((Collection)Objects.requireNonNull(relations, "relations is null"));
    }

    public Intersect(NodeLocation location, List<Relation> relations, boolean distinct) {
        super(Objects.requireNonNull(location, "location is null"), distinct);
        this.relations = ImmutableList.copyOf((Collection)Objects.requireNonNull(relations, "relations is null"));
    }

    @Override
    public List<Relation> getRelations() {
        return this.relations;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIntersect(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.relations;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("relations", this.relations).add("distinct", this.isDistinct()).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Intersect o = (Intersect)obj;
        return Objects.equals(this.relations, o.relations) && Objects.equals(this.isDistinct(), o.isDistinct());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.relations, this.isDistinct());
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!Intersect.sameClass(this, other)) {
            return false;
        }
        return this.isDistinct() == ((Intersect)other).isDistinct();
    }
}

