/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;

public final class BetweenPredicate
extends Expression {
    private final Expression value;
    private final Expression min;
    private final Expression max;

    public BetweenPredicate(Expression value, Expression min, Expression max) {
        super(null);
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(min, "min is null");
        Objects.requireNonNull(max, "max is null");
        this.value = value;
        this.min = min;
        this.max = max;
    }

    public BetweenPredicate(@Nonnull NodeLocation location, Expression value, Expression min, Expression max) {
        super(Objects.requireNonNull(location, "location is null"));
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(min, "min is null");
        Objects.requireNonNull(max, "max is null");
        this.value = value;
        this.min = min;
        this.max = max;
    }

    public Expression getValue() {
        return this.value;
    }

    public Expression getMin() {
        return this.min;
    }

    public Expression getMax() {
        return this.max;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitBetweenPredicate(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.value, (Object)this.min, (Object)this.max);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BetweenPredicate that = (BetweenPredicate)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.min, this.max);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return BetweenPredicate.sameClass(this, other);
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.BETWEEN;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        Expression.serialize(this.value, stream);
        Expression.serialize(this.min, stream);
        Expression.serialize(this.max, stream);
    }

    public BetweenPredicate(ByteBuffer byteBuffer) {
        super(null);
        this.value = Expression.deserialize(byteBuffer);
        this.min = Expression.deserialize(byteBuffer);
        this.max = Expression.deserialize(byteBuffer);
    }
}

