/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.DeviceEntry;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.MetadataUtil;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.TableDeviceSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.ExtractCommonPredicatesExpressionRewriter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AbstractQueryDeviceWithCache;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Table;
import org.apache.tsfile.file.metadata.IDeviceID;

public abstract class AbstractTraverseDevice
extends Statement {
    protected String database;
    protected String tableName;
    protected Table table;
    protected Expression where;
    protected List<List<SchemaFilter>> tagDeterminedFilterList;
    protected Expression tagFuzzyPredicate;
    private List<IDeviceID> partitionKeyList;
    protected List<ColumnHeader> columnHeaderList;
    private List<String> attributeColumns;

    protected AbstractTraverseDevice(NodeLocation location, Table table, Expression where) {
        super(location);
        this.table = table;
        this.where = where;
    }

    protected AbstractTraverseDevice(String database, String tableName) {
        super(null);
        this.database = database;
        this.tableName = tableName;
    }

    public void parseTable(SessionInfo sessionInfo) {
        if (Objects.isNull(this.table)) {
            return;
        }
        QualifiedObjectName objectName = MetadataUtil.createQualifiedObjectName(sessionInfo, this.table.getName());
        this.database = objectName.getDatabaseName();
        this.tableName = objectName.getObjectName();
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Table getTable() {
        return this.table;
    }

    public Optional<Expression> getWhere() {
        return Optional.ofNullable(this.where);
    }

    public void setWhere(Expression where) {
        this.where = where;
    }

    public boolean parseRawExpression(Map<String, List<DeviceEntry>> entries, TsTable tableInstance, List<String> attributeColumns, MPPQueryContext context) {
        if (Objects.isNull(this.where)) {
            return true;
        }
        this.where = ExtractCommonPredicatesExpressionRewriter.extractCommonPredicates(this.where);
        return TableDeviceSchemaFetcher.getInstance().parseFilter4TraverseDevice(tableInstance, this.where instanceof LogicalExpression && ((LogicalExpression)this.where).getOperator() == LogicalExpression.Operator.AND ? ((LogicalExpression)this.where).getTerms() : Collections.singletonList(this.where), this, entries, attributeColumns, context, new AtomicBoolean(false), true);
    }

    public List<List<SchemaFilter>> getTagDeterminedFilterList() {
        if (this.tagDeterminedFilterList == null) {
            this.tagDeterminedFilterList = Collections.singletonList(Collections.emptyList());
        }
        return this.tagDeterminedFilterList;
    }

    public void setTagDeterminedFilterList(List<List<SchemaFilter>> tagDeterminedFilterList) {
        this.tagDeterminedFilterList = tagDeterminedFilterList;
    }

    public Expression getTagFuzzyPredicate() {
        return this.tagFuzzyPredicate;
    }

    public void setTagFuzzyPredicate(Expression tagFuzzyPredicate) {
        this.tagFuzzyPredicate = tagFuzzyPredicate;
    }

    public boolean isIdDetermined() {
        return Objects.nonNull(this.partitionKeyList);
    }

    public List<IDeviceID> getPartitionKeyList() {
        return this.partitionKeyList;
    }

    public void setPartitionKeyList(List<IDeviceID> partitionKeyList) {
        this.partitionKeyList = partitionKeyList;
    }

    public void setAttributeColumns(List<String> attributeColumns) {
        this.attributeColumns = attributeColumns;
    }

    public List<ColumnHeader> getColumnHeaderList() {
        return this.columnHeaderList;
    }

    public void setColumnHeaderList() {
        this.columnHeaderList = AbstractQueryDeviceWithCache.getDeviceColumnHeaderList(this.database, this.tableName, this.attributeColumns);
    }

    @Override
    public List<? extends Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        if (this.where != null) {
            nodes.add((Object)this.where);
        }
        return nodes.build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTraverseDevice that = (AbstractTraverseDevice)o;
        return Objects.equals(this.database, that.database) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.where, that.where) && Objects.equals(this.tagDeterminedFilterList, that.tagDeterminedFilterList) && Objects.equals(this.tagFuzzyPredicate, that.tagFuzzyPredicate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.database, this.tableName, this.where, this.tagDeterminedFilterList, this.tagFuzzyPredicate);
    }

    protected String toStringContent() {
        return "{database='" + this.database + '\'' + ", tableName='" + this.tableName + '\'' + ", rawExpression=" + this.where + ", idDeterminedFilterList=" + this.tagDeterminedFilterList + ", idFuzzyFilter=" + this.tagFuzzyPredicate + '}';
    }
}

