/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.ProjectOffPushDownRule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;

public class PruneAggregationColumns
extends ProjectOffPushDownRule<AggregationNode> {
    public PruneAggregationColumns() {
        super(Patterns.aggregation());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, AggregationNode aggregationNode, Set<Symbol> referencedOutputs) {
        Map prunedAggregations = Maps.filterKeys(aggregationNode.getAggregations(), referencedOutputs::contains);
        if (prunedAggregations.size() == aggregationNode.getAggregations().size()) {
            return Optional.empty();
        }
        return Optional.of(AggregationNode.builderFrom(aggregationNode).setAggregations(prunedAggregations).build());
    }
}

