/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.ir;

import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BetweenPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Cast;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CoalesceExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NotExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullIfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Row;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SearchedCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SimpleCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WhenClause;

public abstract class DefaultTraversalVisitor<C>
extends AstVisitor<Void, C> {
    @Override
    protected Void visitCast(Cast node, C context) {
        this.process(node.getExpression(), context);
        return null;
    }

    @Override
    protected Void visitArithmeticBinary(ArithmeticBinaryExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected Void visitBetweenPredicate(BetweenPredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getMin(), context);
        this.process(node.getMax(), context);
        return null;
    }

    @Override
    protected Void visitCoalesceExpression(CoalesceExpression node, C context) {
        for (Expression operand : node.getOperands()) {
            this.process(operand, context);
        }
        return null;
    }

    @Override
    protected Void visitComparisonExpression(ComparisonExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected Void visitInPredicate(InPredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getValueList(), context);
        return null;
    }

    @Override
    protected Void visitFunctionCall(FunctionCall node, C context) {
        for (Expression argument : node.getArguments()) {
            this.process(argument, context);
        }
        return null;
    }

    @Override
    protected Void visitSimpleCaseExpression(SimpleCaseExpression node, C context) {
        this.process(node.getOperand(), context);
        for (WhenClause clause : node.getWhenClauses()) {
            this.process(clause.getOperand(), context);
            this.process(clause.getResult(), context);
        }
        node.getDefaultValue().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected Void visitNullIfExpression(NullIfExpression node, C context) {
        this.process(node.getFirst(), context);
        this.process(node.getSecond(), context);
        return null;
    }

    @Override
    protected Void visitNotExpression(NotExpression node, C context) {
        this.process(node.getValue(), context);
        return null;
    }

    @Override
    protected Void visitSearchedCaseExpression(SearchedCaseExpression node, C context) {
        for (WhenClause clause : node.getWhenClauses()) {
            this.process(clause.getOperand(), context);
            this.process(clause.getResult(), context);
        }
        node.getDefaultValue().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected Void visitIsNullPredicate(IsNullPredicate node, C context) {
        this.process(node.getValue(), context);
        return null;
    }

    @Override
    protected Void visitLogicalExpression(LogicalExpression node, C context) {
        for (Expression child : node.getTerms()) {
            this.process(child, context);
        }
        return null;
    }

    @Override
    protected Void visitRow(Row node, C context) {
        for (Expression expression : node.getItems()) {
            this.process(expression, context);
        }
        return null;
    }
}

