/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.db.queryengine.common.schematree.IMeasurementSchemaInfo;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class SchemaCacheEntry
implements IMeasurementSchemaInfo {
    private static final int INSTANCE_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(SchemaCacheEntry.class) + 75;
    private final IMeasurementSchema iMeasurementSchema;
    private final Map<String, String> tagMap;

    public SchemaCacheEntry(@Nonnull IMeasurementSchema iMeasurementSchema, @Nullable Map<String, String> tagMap) {
        this.iMeasurementSchema = iMeasurementSchema;
        this.tagMap = tagMap;
    }

    @Override
    public Map<String, String> getTagMap() {
        return this.tagMap;
    }

    @Override
    public Map<String, String> getAttributeMap() {
        return null;
    }

    public TSDataType getTsDataType() {
        return this.iMeasurementSchema.getType();
    }

    public static int estimateSize(SchemaCacheEntry schemaCacheEntry) {
        return INSTANCE_SIZE + 2 * schemaCacheEntry.getSchema().getMeasurementName().length() + (int)RamUsageEstimator.sizeOfMap(schemaCacheEntry.getTagMap());
    }

    @Override
    public String getName() {
        return this.iMeasurementSchema.getMeasurementName();
    }

    @Override
    public IMeasurementSchema getSchema() {
        return this.iMeasurementSchema;
    }

    @Override
    public MeasurementSchema getSchemaAsMeasurementSchema() {
        if (this.iMeasurementSchema instanceof MeasurementSchema) {
            return (MeasurementSchema)this.getSchema();
        }
        return null;
    }

    @Override
    public LogicalViewSchema getSchemaAsLogicalViewSchema() {
        if (this.iMeasurementSchema instanceof LogicalViewSchema) {
            return (LogicalViewSchema)this.getSchema();
        }
        return null;
    }

    @Override
    public String getAlias() {
        return null;
    }

    @Override
    public boolean isLogicalView() {
        return this.iMeasurementSchema.isLogicalView();
    }
}

