/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.analyzer.tablefunction;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.OrderBy;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Relation;

public class TableArgumentAnalysis {
    private final String argumentName;
    private final Optional<QualifiedName> name;
    private final Relation relation;
    private final Optional<List<Expression>> partitionBy;
    private final Optional<OrderBy> orderBy;
    private final boolean rowSemantics;
    private final boolean passThroughColumns;

    private TableArgumentAnalysis(String argumentName, Optional<QualifiedName> name, Relation relation, Optional<List<Expression>> partitionBy, Optional<OrderBy> orderBy, boolean rowSemantics, boolean passThroughColumns) {
        this.argumentName = Objects.requireNonNull(argumentName, "argumentName is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.relation = Objects.requireNonNull(relation, "relation is null");
        this.partitionBy = Objects.requireNonNull(partitionBy, "partitionBy is null").map(ImmutableList::copyOf);
        this.orderBy = Objects.requireNonNull(orderBy, "orderBy is null");
        this.rowSemantics = rowSemantics;
        this.passThroughColumns = passThroughColumns;
    }

    public String getArgumentName() {
        return this.argumentName;
    }

    public Optional<QualifiedName> getName() {
        return this.name;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public Optional<List<Expression>> getPartitionBy() {
        return this.partitionBy;
    }

    public Optional<OrderBy> getOrderBy() {
        return this.orderBy;
    }

    public boolean isRowSemantics() {
        return this.rowSemantics;
    }

    public boolean isPassThroughColumns() {
        return this.passThroughColumns;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String argumentName;
        private Optional<QualifiedName> name = Optional.empty();
        private Relation relation;
        private Optional<List<Expression>> partitionBy = Optional.empty();
        private Optional<OrderBy> orderBy = Optional.empty();
        private boolean rowSemantics;
        private boolean passThroughColumns;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder withArgumentName(String argumentName) {
            this.argumentName = argumentName;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withName(QualifiedName name) {
            this.name = Optional.of(name);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withRelation(Relation relation) {
            this.relation = relation;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withPartitionBy(List<Expression> partitionBy) {
            this.partitionBy = Optional.of(partitionBy);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withOrderBy(OrderBy orderBy) {
            this.orderBy = Optional.of(orderBy);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withRowSemantics(boolean rowSemantics) {
            this.rowSemantics = rowSemantics;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withPassThroughColumns(boolean passThroughColumns) {
            this.passThroughColumns = passThroughColumns;
            return this;
        }

        public TableArgumentAnalysis build() {
            return new TableArgumentAnalysis(this.argumentName, this.name, this.relation, this.partitionBy, this.orderBy, this.rowSemantics, this.passThroughColumns);
        }
    }
}

