/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.analyzer.predicate;

import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticUnaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BetweenPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BinaryLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Cast;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CoalesceExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CurrentDatabase;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CurrentTime;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CurrentUser;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DecimalLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DoubleLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GenericLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InListExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNotNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LikePredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NotExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullIfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SearchedCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SimpleCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StringLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Trim;

public class PredicatePushIntoMetadataChecker
extends AstVisitor<Boolean, Void> {
    private final Set<String> idOrAttributeColumnNames;

    public static boolean check(Set<String> idOrAttributeColumnNames, Expression expression) {
        return (Boolean)new PredicatePushIntoMetadataChecker(idOrAttributeColumnNames).process(expression);
    }

    public PredicatePushIntoMetadataChecker(Set<String> idOrAttributeColumnNames) {
        this.idOrAttributeColumnNames = idOrAttributeColumnNames;
    }

    @Override
    public Boolean visitExpression(Expression expression, Void context) {
        return Boolean.FALSE;
    }

    @Override
    protected Boolean visitArithmeticBinary(ArithmeticBinaryExpression node, Void context) {
        return node.getLeft().accept(this, context) != false && node.getRight().accept(this, context) != false;
    }

    @Override
    protected Boolean visitArithmeticUnary(ArithmeticUnaryExpression node, Void context) {
        return node.getValue().accept(this, context);
    }

    @Override
    protected Boolean visitBetweenPredicate(BetweenPredicate node, Void context) {
        return node.getValue().accept(this, context) != false && node.getMin().accept(this, context) != false && node.getMax().accept(this, context) != false;
    }

    @Override
    protected Boolean visitCast(Cast node, Void context) {
        return node.getExpression().accept(this, context);
    }

    @Override
    protected Boolean visitBooleanLiteral(BooleanLiteral node, Void context) {
        return true;
    }

    @Override
    protected Boolean visitBinaryLiteral(BinaryLiteral node, Void context) {
        return true;
    }

    @Override
    protected Boolean visitStringLiteral(StringLiteral node, Void context) {
        return true;
    }

    @Override
    protected Boolean visitLongLiteral(LongLiteral node, Void context) {
        return true;
    }

    @Override
    protected Boolean visitDoubleLiteral(DoubleLiteral node, Void context) {
        return true;
    }

    @Override
    protected Boolean visitDecimalLiteral(DecimalLiteral node, Void context) {
        return true;
    }

    @Override
    protected Boolean visitGenericLiteral(GenericLiteral node, Void context) {
        return true;
    }

    @Override
    protected Boolean visitNullLiteral(NullLiteral node, Void context) {
        return true;
    }

    @Override
    protected Boolean visitComparisonExpression(ComparisonExpression node, Void context) {
        return node.getLeft().accept(this, context) != false && node.getRight().accept(this, context) != false;
    }

    @Override
    protected Boolean visitCurrentDatabase(CurrentDatabase node, Void context) {
        return true;
    }

    @Override
    protected Boolean visitCurrentTime(CurrentTime node, Void context) {
        return true;
    }

    @Override
    protected Boolean visitCurrentUser(CurrentUser node, Void context) {
        return true;
    }

    @Override
    protected Boolean visitFunctionCall(FunctionCall node, Void context) {
        return node.getArguments().stream().allMatch(expression -> expression.accept(this, context));
    }

    @Override
    protected Boolean visitInPredicate(InPredicate node, Void context) {
        return node.getValue().accept(this, context) != false && node.getValueList().accept(this, context) != false;
    }

    @Override
    protected Boolean visitInListExpression(InListExpression node, Void context) {
        return node.getValues().stream().allMatch(expression -> expression.accept(this, context));
    }

    @Override
    protected Boolean visitIsNullPredicate(IsNullPredicate node, Void context) {
        return node.getValue().accept(this, context);
    }

    @Override
    protected Boolean visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
        return node.getValue().accept(this, context);
    }

    @Override
    protected Boolean visitLikePredicate(LikePredicate node, Void context) {
        return node.getValue().accept(this, context);
    }

    @Override
    protected Boolean visitLogicalExpression(LogicalExpression node, Void context) {
        List<Expression> children = node.getTerms();
        for (Expression child : children) {
            Boolean result = (Boolean)this.process(child, context);
            if (result == null) {
                throw new IllegalStateException("Should never return null.");
            }
            if (result.booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    protected Boolean visitNotExpression(NotExpression node, Void context) {
        if (node.getValue() instanceof Literal) {
            return Boolean.FALSE;
        }
        return node.getValue().accept(this, context);
    }

    @Override
    protected Boolean visitSymbolReference(SymbolReference node, Void context) {
        return this.idOrAttributeColumnNames.contains(node.getName());
    }

    @Override
    protected Boolean visitCoalesceExpression(CoalesceExpression node, Void context) {
        return Boolean.FALSE;
    }

    @Override
    protected Boolean visitSimpleCaseExpression(SimpleCaseExpression node, Void context) {
        return Boolean.FALSE;
    }

    @Override
    protected Boolean visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
        return Boolean.FALSE;
    }

    @Override
    protected Boolean visitTrim(Trim node, Void context) {
        return node.getTrimSource().accept(this, context) != false && (!node.getTrimCharacter().isPresent() || ((Expression)node.getTrimCharacter().orElse(null)).accept(this, context) != false);
    }

    @Override
    protected Boolean visitIfExpression(IfExpression node, Void context) {
        return Boolean.FALSE;
    }

    @Override
    protected Boolean visitNullIfExpression(NullIfExpression node, Void context) {
        return Boolean.FALSE;
    }

    public static boolean isStringLiteral(Expression expression) {
        return expression instanceof StringLiteral;
    }
}

