/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array;

import java.util.Arrays;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.BigArrays;
import org.apache.tsfile.utils.RamUsageEstimator;

public final class LongBigArray {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(LongBigArray.class);
    private static final long SIZE_OF_SEGMENT = RamUsageEstimator.sizeOfLongArray((int)1024);
    private final long initialValue;
    private long[][] array;
    private long capacity;
    private int segments;

    public LongBigArray() {
        this(0L);
    }

    public LongBigArray(long initialValue) {
        this.initialValue = initialValue;
        this.array = new long[1024][];
        this.allocateNewSegment();
    }

    public long sizeOf() {
        return INSTANCE_SIZE + RamUsageEstimator.shallowSizeOf((Object[])this.array) + (long)this.segments * SIZE_OF_SEGMENT;
    }

    public long get(long index) {
        return this.array[BigArrays.segment(index)][BigArrays.offset(index)];
    }

    public long[] getSegment(long index) {
        return this.array[BigArrays.segment(index)];
    }

    public int getOffset(long index) {
        return BigArrays.offset(index);
    }

    public void set(long index, long value) {
        this.array[BigArrays.segment((long)index)][BigArrays.offset((long)index)] = value;
    }

    public void increment(long index) {
        long[] lArray = this.array[BigArrays.segment(index)];
        int n = BigArrays.offset(index);
        lArray[n] = lArray[n] + 1L;
    }

    public void add(long index, long value) {
        long[] lArray = this.array[BigArrays.segment(index)];
        int n = BigArrays.offset(index);
        lArray[n] = lArray[n] + value;
    }

    public void ensureCapacity(long length) {
        if (this.capacity > length) {
            return;
        }
        this.grow(length);
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void copyTo(long sourceIndex, LongBigArray destination, long destinationIndex, long length) {
        while (length > 0L) {
            int startSegment = BigArrays.segment(sourceIndex);
            int startOffset = BigArrays.offset(sourceIndex);
            int destinationStartSegment = BigArrays.segment(destinationIndex);
            int destinationStartOffset = BigArrays.offset(destinationIndex);
            int copyLength = Math.min(1024 - startOffset, 1024 - destinationStartOffset);
            copyLength = Math.min(copyLength, length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length);
            System.arraycopy(this.array[startSegment], startOffset, destination.array[destinationStartSegment], destinationStartOffset, copyLength);
            sourceIndex += (long)copyLength;
            destinationIndex += (long)copyLength;
            length -= (long)copyLength;
        }
    }

    public void fill(long value) {
        for (long[] segment : this.array) {
            if (segment == null) {
                return;
            }
            Arrays.fill(segment, value);
        }
    }

    public void reset() {
        this.fill(this.initialValue);
    }

    private void grow(long length) {
        int requiredSegments = BigArrays.segment(length) + 1;
        if (this.array.length < requiredSegments) {
            this.array = (long[][])Arrays.copyOf(this.array, requiredSegments);
        }
        while (this.segments < requiredSegments) {
            this.allocateNewSegment();
        }
    }

    private void allocateNewSegment() {
        long[] newSegment = new long[1024];
        if (this.initialValue != 0L) {
            Arrays.fill(newSegment, this.initialValue);
        }
        this.array[this.segments] = newSegment;
        this.capacity += 1024L;
        ++this.segments;
    }
}

