/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.AbstractDataSourceOperator;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.DeviceEntry;
import org.apache.iotdb.db.storageengine.dataregion.read.IQueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class DeviceIteratorScanOperator
extends AbstractDataSourceOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(DeviceIteratorScanOperator.class);
    private final OperatorContext operatorContext;
    private final List<DeviceEntry> deviceEntries;
    private final DeviceChildOperatorTreeGenerator deviceChildOperatorTreeGenerator;
    private QueryDataSource queryDataSource;
    private int currentDeviceIndex;
    private Operator currentDeviceRootOperator;
    private List<Operator> dataSourceOperators;
    private boolean currentDeviceInit;

    public DeviceIteratorScanOperator(OperatorContext operatorContext, List<DeviceEntry> deviceEntries, DeviceChildOperatorTreeGenerator childOperatorTreeGenerator) {
        this.operatorContext = operatorContext;
        this.deviceEntries = deviceEntries;
        this.deviceChildOperatorTreeGenerator = childOperatorTreeGenerator;
        this.currentDeviceIndex = 0;
        this.currentDeviceInit = false;
        this.operatorContext.recordSpecifiedInfo("CurrentDeviceIndex", Integer.toString(0));
        this.constructCurrentDeviceOperatorTree();
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.currentDeviceRootOperator != null && this.currentDeviceRootOperator.hasNext()) {
            return true;
        }
        if (!this.currentDeviceInit) {
            return true;
        }
        if (this.currentDeviceIndex + 1 >= this.deviceEntries.size()) {
            return false;
        }
        this.nextDevice();
        return true;
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNext();
    }

    private void nextDevice() throws Exception {
        ++this.currentDeviceIndex;
        this.deviceChildOperatorTreeGenerator.getCurrentDeviceStartCloseOperator().close();
        if (this.currentDeviceIndex >= this.deviceEntries.size()) {
            return;
        }
        this.constructCurrentDeviceOperatorTree();
        this.queryDataSource.reset();
        this.initQueryDataSource(this.queryDataSource);
        this.operatorContext.recordSpecifiedInfo("CurrentDeviceIndex", Integer.toString(this.currentDeviceIndex));
    }

    private void constructCurrentDeviceOperatorTree() {
        if (this.deviceEntries.isEmpty()) {
            return;
        }
        if (this.deviceEntries.get(this.currentDeviceIndex) == null) {
            throw new IllegalStateException("Device entries of index " + this.currentDeviceIndex + " is empty");
        }
        DeviceEntry deviceEntry = this.deviceEntries.get(this.currentDeviceIndex);
        this.deviceChildOperatorTreeGenerator.generateCurrentDeviceOperatorTree(deviceEntry);
        this.currentDeviceRootOperator = this.deviceChildOperatorTreeGenerator.getCurrentDeviceRootOperator();
        this.dataSourceOperators = this.deviceChildOperatorTreeGenerator.getCurrentDeviceDataSourceOperators();
        this.currentDeviceInit = false;
    }

    @Override
    public void initQueryDataSource(IQueryDataSource dataSource) {
        this.queryDataSource = (QueryDataSource)dataSource;
        if (this.dataSourceOperators == null || this.dataSourceOperators.isEmpty()) {
            return;
        }
        for (Operator operator : this.dataSourceOperators) {
            ((AbstractDataSourceOperator)operator).initQueryDataSource(dataSource);
        }
    }

    @Override
    public TsBlock next() throws Exception {
        if (!this.hasNext()) {
            return null;
        }
        if (!this.currentDeviceInit) {
            return null;
        }
        return this.currentDeviceRootOperator.next();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        this.currentDeviceInit = true;
        return this.currentDeviceRootOperator.isBlocked();
    }

    @Override
    public void close() throws Exception {
        if (this.currentDeviceRootOperator != null) {
            this.currentDeviceRootOperator.close();
        }
    }

    @Override
    protected List<TSDataType> getResultDataTypes() {
        throw new UnsupportedOperationException("Should not call getResultDataTypes() method in DeviceIteratorScanOperator");
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.currentDeviceRootOperator.calculateMaxPeekMemory();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.currentDeviceRootOperator.calculateMaxReturnSize();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.currentDeviceRootOperator.calculateRetainedSizeAfterCallingNext();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.currentDeviceRootOperator) + RamUsageEstimator.sizeOfCollection(this.deviceEntries);
    }

    public static interface DeviceChildOperatorTreeGenerator {
        public boolean keepOffsetAndLimitOperatorAfterDeviceIterator();

        public void generateCurrentDeviceOperatorTree(DeviceEntry var1);

        public Operator getCurrentDeviceRootOperator();

        public List<Operator> getCurrentDeviceDataSourceOperators();

        public Operator getCurrentDeviceStartCloseOperator();
    }

    public static class TreeNonAlignedDeviceViewScanParameters {
        public final OperatorContext context;
        public final List<DeviceEntry> deviceEntries;
        public final List<String> measurementColumnNames;
        public final Set<String> allSensors;
        public final List<IMeasurementSchema> measurementSchemas;
        public final DeviceChildOperatorTreeGenerator generator;

        public TreeNonAlignedDeviceViewScanParameters(Set<String> allSensors, OperatorContext context, List<DeviceEntry> deviceEntries, List<String> measurementColumnNames, List<IMeasurementSchema> measurementSchemas, DeviceChildOperatorTreeGenerator generator) {
            this.allSensors = allSensors;
            this.context = context;
            this.deviceEntries = deviceEntries;
            this.measurementColumnNames = measurementColumnNames;
            this.measurementSchemas = measurementSchemas;
            this.generator = generator;
        }
    }
}

