/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher;

import java.util.Arrays;
import org.apache.tsfile.utils.RamUsageEstimator;

class IntStack {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(IntStack.class);
    private int[] values;
    private int next;

    public IntStack(int capacity) {
        this.values = new int[capacity];
    }

    public void push(int value) {
        this.ensureCapacity();
        this.values[this.next] = value;
        ++this.next;
    }

    public int pop() {
        --this.next;
        return this.values[this.next];
    }

    public int size() {
        return this.next;
    }

    private void ensureCapacity() {
        if (this.next == this.values.length) {
            this.values = Arrays.copyOf(this.values, this.next * 2 + 1);
        }
    }

    public long getSizeInBytes() {
        return INSTANCE_SIZE + RamUsageEstimator.sizeOf((int[])this.values);
    }
}

