/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.builder;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.consensus.pipe.thrift.TCommitId;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferReq;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.request.PipeConsensusTabletBatchReq;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.request.PipeConsensusTabletBinaryReq;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.request.PipeConsensusTabletInsertNodeReq;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.WALPipeException;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeConsensusTransferBatchReqBuilder
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConsensusTransferBatchReqBuilder.class);
    protected final List<EnrichedEvent> events = new ArrayList<EnrichedEvent>();
    protected final List<Long> requestCommitIds = new ArrayList<Long>();
    protected final List<TPipeConsensusTransferReq> batchReqs = new ArrayList<TPipeConsensusTransferReq>();
    protected final int maxDelayInMs;
    protected final TConsensusGroupId consensusGroupId;
    protected final int thisDataNodeId;
    protected long firstEventProcessingTime = Long.MIN_VALUE;
    protected final PipeMemoryBlock allocatedMemoryBlock;
    protected long totalBufferSize = 0L;

    protected PipeConsensusTransferBatchReqBuilder(PipeParameters parameters, TConsensusGroupId consensusGroupId, int thisDataNodeId) {
        int requestMaxDelayInSeconds;
        Integer requestMaxDelayInMillis = parameters.getIntByKeys(new String[]{"connector.batch.max-delay-ms", "sink.batch.max-delay-ms"});
        this.maxDelayInMs = Objects.isNull(requestMaxDelayInMillis) ? ((requestMaxDelayInSeconds = parameters.getIntOrDefault(Arrays.asList("connector.batch.max-delay-seconds", "sink.batch.max-delay-seconds"), 1)) < 0 ? Integer.MAX_VALUE : requestMaxDelayInSeconds * 1000) : (requestMaxDelayInMillis < 0 ? Integer.MAX_VALUE : requestMaxDelayInMillis);
        this.consensusGroupId = consensusGroupId;
        this.thisDataNodeId = thisDataNodeId;
        long requestMaxBatchSizeInBytes = parameters.getLongOrDefault(Arrays.asList("connector.batch.size-bytes", "sink.batch.size-bytes"), 0x100000L);
        this.allocatedMemoryBlock = PipeDataNodeResourceManager.memory().tryAllocate(requestMaxBatchSizeInBytes).setShrinkMethod(oldMemory -> Math.max(oldMemory / 2L, 0L)).setShrinkCallback((oldMemory, newMemory) -> LOGGER.info("The batch size limit has shrunk from {} to {}.", oldMemory, newMemory)).setExpandMethod(oldMemory -> Math.min(Math.max(oldMemory, 1L) * 2L, requestMaxBatchSizeInBytes)).setExpandCallback((oldMemory, newMemory) -> LOGGER.info("The batch size limit has expanded from {} to {}.", oldMemory, newMemory));
        if (this.getMaxBatchSizeInBytes() != requestMaxBatchSizeInBytes) {
            LOGGER.info("PipeConsensusTransferBatchReqBuilder: the max batch size is adjusted from {} to {} due to the memory restriction", (Object)requestMaxBatchSizeInBytes, (Object)this.getMaxBatchSizeInBytes());
        }
    }

    public synchronized boolean onEvent(TabletInsertionEvent event) throws IOException, WALPipeException {
        if (!(event instanceof EnrichedEvent)) {
            return false;
        }
        long requestCommitId = ((EnrichedEvent)event).getReplicateIndexForIoTV2();
        if (this.events.isEmpty() || !this.events.get(this.events.size() - 1).equals(event)) {
            this.events.add((EnrichedEvent)event);
            this.requestCommitIds.add(requestCommitId);
            int bufferSize = this.buildTabletInsertionBuffer(event);
            ((EnrichedEvent)event).increaseReferenceCount(PipeConsensusTransferBatchReqBuilder.class.getName());
            if (this.firstEventProcessingTime == Long.MIN_VALUE) {
                this.firstEventProcessingTime = System.currentTimeMillis();
            }
            this.totalBufferSize += (long)bufferSize;
        }
        return this.totalBufferSize >= this.getMaxBatchSizeInBytes() || System.currentTimeMillis() - this.firstEventProcessingTime >= (long)this.maxDelayInMs;
    }

    public synchronized void onSuccess() {
        this.batchReqs.clear();
        this.events.clear();
        this.requestCommitIds.clear();
        this.firstEventProcessingTime = Long.MIN_VALUE;
        this.totalBufferSize = 0L;
    }

    public PipeConsensusTabletBatchReq toTPipeConsensusBatchTransferReq() throws IOException {
        return PipeConsensusTabletBatchReq.toTPipeConsensusBatchTransferReq(this.batchReqs);
    }

    protected long getMaxBatchSizeInBytes() {
        return this.allocatedMemoryBlock.getMemoryUsageInBytes();
    }

    public boolean isEmpty() {
        return this.batchReqs.isEmpty();
    }

    public List<EnrichedEvent> deepCopyEvents() {
        return new ArrayList<EnrichedEvent>(this.events);
    }

    protected int buildTabletInsertionBuffer(TabletInsertionEvent event) throws WALPipeException {
        ByteBuffer buffer;
        PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent = (PipeInsertNodeTabletInsertionEvent)event;
        TCommitId commitId = new TCommitId(pipeInsertNodeTabletInsertionEvent.getReplicateIndexForIoTV2(), pipeInsertNodeTabletInsertionEvent.getCommitterKey().getRestartTimes(), pipeInsertNodeTabletInsertionEvent.getRebootTimes());
        InsertNode insertNode = pipeInsertNodeTabletInsertionEvent.getInsertNode();
        ProgressIndex progressIndex = pipeInsertNodeTabletInsertionEvent.getProgressIndex();
        if (Objects.isNull(insertNode)) {
            buffer = pipeInsertNodeTabletInsertionEvent.getByteBuffer();
            this.batchReqs.add(PipeConsensusTabletBinaryReq.toTPipeConsensusTransferReq(buffer, commitId, this.consensusGroupId, progressIndex, this.thisDataNodeId));
        } else {
            buffer = insertNode.serializeToByteBuffer();
            this.batchReqs.add(PipeConsensusTabletInsertNodeReq.toTPipeConsensusTransferReq(insertNode, commitId, this.consensusGroupId, progressIndex, this.thisDataNodeId));
        }
        return buffer.limit();
    }

    @Override
    public synchronized void close() {
        for (Event event : this.events) {
            if (!(event instanceof EnrichedEvent)) continue;
            ((EnrichedEvent)event).clearReferenceCount(this.getClass().getName());
        }
        this.allocatedMemoryBlock.close();
    }
}

