/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.apache.ratis.util.TimeDuration;

public final class AutoCloseableLock
implements AutoCloseable {
    private final Lock underlying;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Runnable preUnlock;

    public static AutoCloseableLock acquire(Lock lock) {
        return AutoCloseableLock.acquire(lock, null);
    }

    public static AutoCloseableLock acquire(Lock lock, Runnable preUnlock) {
        lock.lock();
        return new AutoCloseableLock(lock, preUnlock);
    }

    public static AutoCloseableLock tryAcquire(Lock lock, Runnable preUnlock, TimeDuration timeout) throws InterruptedException {
        Objects.requireNonNull(timeout, "timeout == null");
        boolean locked = lock.tryLock(timeout.getDuration(), timeout.getUnit());
        return locked ? new AutoCloseableLock(lock, preUnlock) : null;
    }

    private AutoCloseableLock(Lock underlying, Runnable preUnlock) {
        this.underlying = underlying;
        this.preUnlock = preUnlock;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                if (this.preUnlock != null) {
                    this.preUnlock.run();
                }
            }
            finally {
                this.underlying.unlock();
            }
        }
    }
}

