/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client.factory;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.exception.CreateTAsyncClientManagerException;
import org.apache.iotdb.commons.client.factory.ThriftClientFactory;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.thrift.async.TAsyncClientManager;

public abstract class AsyncThriftClientFactory<K, V>
extends ThriftClientFactory<K, V> {
    protected final TAsyncClientManager[] tManagers;
    protected final AtomicInteger clientCnt = new AtomicInteger();
    private static final String THRIFT_THREAD_NAME = "TAsyncClientManager#SelectorThread";

    protected AsyncThriftClientFactory(ClientManager<K, V> clientManager, ThriftClientProperty thriftClientProperty, String threadName) {
        super(clientManager, thriftClientProperty);
        try {
            this.tManagers = new TAsyncClientManager[thriftClientProperty.getSelectorNumOfAsyncClientPool()];
            for (int i = 0; i < this.tManagers.length; ++i) {
                this.tManagers[i] = new TAsyncClientManager();
            }
        }
        catch (IOException e) {
            throw new CreateTAsyncClientManagerException(String.format("Cannot create Async thrift client factory %s", threadName), e);
        }
        Thread.getAllStackTraces().keySet().stream().filter(thread -> thread.getName().contains(THRIFT_THREAD_NAME)).collect(Collectors.toList()).forEach(thread -> thread.setName(threadName + "-selector-" + thread.getId()));
    }

    public void close() {
        for (TAsyncClientManager tManager : this.tManagers) {
            tManager.stop();
        }
    }
}

