/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.memtable;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemChunkLoader;
import org.apache.iotdb.db.utils.datastructure.MemPointIterator;
import org.apache.iotdb.db.utils.datastructure.MemPointIteratorFactory;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.controller.IChunkLoader;
import org.apache.tsfile.read.reader.IPointReader;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyMemChunk {
    protected final QueryContext context;
    private String measurementUid;
    private TSDataType dataType;
    private static final Logger logger = LoggerFactory.getLogger(ReadOnlyMemChunk.class);
    protected IChunkMetadata cachedMetaData;
    private int floatPrecision;
    private TSEncoding encoding;
    private List<TimeRange> deletionList;
    private List<Statistics<? extends Serializable>> pageStatisticsList;
    private Map<TVList, Integer> tvListQueryMap;
    private MemPointIterator timeValuePairIterator;
    protected final int MAX_NUMBER_OF_POINTS_IN_PAGE = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();

    protected ReadOnlyMemChunk(QueryContext context) {
        this.context = context;
    }

    public ReadOnlyMemChunk(QueryContext context, String measurementUid, TSDataType dataType, TSEncoding encoding, Map<TVList, Integer> tvListQueryMap, Map<String, String> props, List<TimeRange> deletionList) throws IOException, QueryProcessException {
        this.context = context;
        this.measurementUid = measurementUid;
        this.dataType = dataType;
        int floatPrecision = TSFileDescriptor.getInstance().getConfig().getFloatPrecision();
        if (props != null && props.containsKey("max_point_number")) {
            try {
                floatPrecision = Integer.parseInt(props.get("max_point_number"));
            }
            catch (NumberFormatException e) {
                logger.warn("The format of MAX_POINT_NUMBER {}  is not correct. Using default float precision.", (Object)props.get("max_point_number"));
            }
            if (floatPrecision < 0) {
                logger.warn("The MAX_POINT_NUMBER shouldn't be less than 0. Using default float precision {}.", (Object)TSFileDescriptor.getInstance().getConfig().getFloatPrecision());
                floatPrecision = TSFileDescriptor.getInstance().getConfig().getFloatPrecision();
            }
        }
        this.floatPrecision = floatPrecision;
        this.encoding = encoding;
        this.deletionList = deletionList;
        this.tvListQueryMap = tvListQueryMap;
        this.pageStatisticsList = new ArrayList<Statistics<? extends Serializable>>();
        this.context.addTVListToSet(tvListQueryMap);
    }

    public void sortTvLists() {
        for (Map.Entry<TVList, Integer> entry : this.getTvListQueryMap().entrySet()) {
            TVList tvList = entry.getKey();
            int queryRowCount = entry.getValue();
            if (tvList.isSorted() || queryRowCount <= tvList.seqRowCount()) continue;
            tvList.sort();
        }
    }

    public void initChunkMetaFromTvLists() {
        Statistics chunkStatistics = Statistics.getStatsByType((TSDataType)this.dataType);
        ArrayList<TVList> tvLists = new ArrayList<TVList>(this.tvListQueryMap.keySet());
        this.timeValuePairIterator = MemPointIteratorFactory.create(this.dataType, tvLists, this.deletionList, this.floatPrecision, this.encoding, this.MAX_NUMBER_OF_POINTS_IN_PAGE);
        block8: while (this.timeValuePairIterator.hasNextBatch()) {
            Statistics pageStatistics = Statistics.getStatsByType((TSDataType)this.dataType);
            this.pageStatisticsList.add((Statistics<? extends Serializable>)pageStatistics);
            TsBlock tsBlock = this.timeValuePairIterator.nextBatch();
            if (tsBlock.isEmpty()) continue;
            switch (this.dataType) {
                case BOOLEAN: {
                    long time;
                    int i;
                    for (i = 0; i < tsBlock.getPositionCount(); ++i) {
                        time = tsBlock.getTimeByIndex(i);
                        chunkStatistics.update(time, tsBlock.getColumn(0).getBoolean(i));
                        pageStatistics.update(time, tsBlock.getColumn(0).getBoolean(i));
                    }
                    continue block8;
                }
                case INT32: 
                case DATE: {
                    long time;
                    int i;
                    for (i = 0; i < tsBlock.getPositionCount(); ++i) {
                        time = tsBlock.getTimeByIndex(i);
                        chunkStatistics.update(time, tsBlock.getColumn(0).getInt(i));
                        pageStatistics.update(time, tsBlock.getColumn(0).getInt(i));
                    }
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    long time;
                    int i;
                    for (i = 0; i < tsBlock.getPositionCount(); ++i) {
                        time = tsBlock.getTimeByIndex(i);
                        chunkStatistics.update(time, tsBlock.getColumn(0).getLong(i));
                        pageStatistics.update(time, tsBlock.getColumn(0).getLong(i));
                    }
                    continue block8;
                }
                case FLOAT: {
                    long time;
                    int i;
                    for (i = 0; i < tsBlock.getPositionCount(); ++i) {
                        time = tsBlock.getTimeByIndex(i);
                        chunkStatistics.update(time, tsBlock.getColumn(0).getFloat(i));
                        pageStatistics.update(time, tsBlock.getColumn(0).getFloat(i));
                    }
                    continue block8;
                }
                case DOUBLE: {
                    long time;
                    int i;
                    for (i = 0; i < tsBlock.getPositionCount(); ++i) {
                        time = tsBlock.getTimeByIndex(i);
                        chunkStatistics.update(time, tsBlock.getColumn(0).getDouble(i));
                        pageStatistics.update(time, tsBlock.getColumn(0).getDouble(i));
                    }
                    continue block8;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    long time;
                    int i;
                    for (i = 0; i < tsBlock.getPositionCount(); ++i) {
                        time = tsBlock.getTimeByIndex(i);
                        chunkStatistics.update(time, tsBlock.getColumn(0).getBinary(i));
                        pageStatistics.update(time, tsBlock.getColumn(0).getBinary(i));
                    }
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.dataType));
                }
            }
        }
        ChunkMetadata metaData = new ChunkMetadata(this.measurementUid, this.dataType, 0L, chunkStatistics);
        metaData.setChunkLoader((IChunkLoader)new MemChunkLoader(this.context, this));
        metaData.setVersion(Long.MAX_VALUE);
        this.cachedMetaData = metaData;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public IChunkMetadata getChunkMetaData() {
        return this.cachedMetaData;
    }

    public IPointReader getPointReader() {
        for (Map.Entry<TVList, Integer> entry : this.tvListQueryMap.entrySet()) {
            TVList tvList = entry.getKey();
            int queryLength = entry.getValue();
            if (tvList.isSorted() || queryLength <= tvList.seqRowCount()) continue;
            tvList.sort();
        }
        TsBlock tsBlock = this.buildTsBlock();
        return tsBlock.getTsBlockSingleColumnIterator();
    }

    private TsBlock buildTsBlock() {
        try {
            TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(this.dataType));
            this.writeValidValuesIntoTsBlock(builder);
            return builder.build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeValidValuesIntoTsBlock(TsBlockBuilder builder) throws IOException {
        ArrayList<TVList> tvLists = new ArrayList<TVList>(this.tvListQueryMap.keySet());
        MemPointIterator timeValuePairIterator = MemPointIteratorFactory.create(this.getDataType(), tvLists, this.deletionList, this.floatPrecision, this.encoding, this.MAX_NUMBER_OF_POINTS_IN_PAGE);
        while (timeValuePairIterator.hasNextTimeValuePair()) {
            TimeValuePair tvPair = timeValuePairIterator.nextTimeValuePair();
            builder.getTimeColumnBuilder().writeLong(tvPair.getTimestamp());
            switch (this.dataType) {
                case BOOLEAN: {
                    builder.getColumnBuilder(0).writeBoolean(tvPair.getValue().getBoolean());
                    break;
                }
                case INT32: 
                case DATE: {
                    builder.getColumnBuilder(0).writeInt(tvPair.getValue().getInt());
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    builder.getColumnBuilder(0).writeLong(tvPair.getValue().getLong());
                    break;
                }
                case FLOAT: {
                    builder.getColumnBuilder(0).writeFloat(tvPair.getValue().getFloat());
                    break;
                }
                case DOUBLE: {
                    builder.getColumnBuilder(0).writeDouble(tvPair.getValue().getDouble());
                    break;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    builder.getColumnBuilder(0).writeBinary(tvPair.getValue().getBinary());
                    break;
                }
            }
            builder.declarePosition();
        }
    }

    public Map<TVList, Integer> getTvListQueryMap() {
        return this.tvListQueryMap;
    }

    private int count() {
        int count = 0;
        for (TVList list : this.tvListQueryMap.keySet()) {
            count += list.count();
        }
        return count;
    }

    public int getFloatPrecision() {
        return this.floatPrecision;
    }

    public TSEncoding getEncoding() {
        return this.encoding;
    }

    public List<TimeRange> getDeletionList() {
        return this.deletionList;
    }

    public List<Statistics<? extends Serializable>> getPageStatisticsList() {
        return this.pageStatisticsList;
    }

    public QueryContext getContext() {
        return this.context;
    }

    public TsBlock getTsBlock() {
        return null;
    }

    public MemPointIterator getMemPointIterator() {
        return this.timeValuePairIterator;
    }
}

