/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.region;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.exception.runtime.ThriftSerDeException;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.region.AddRegionPeerProcedure;
import org.apache.iotdb.confignode.procedure.impl.region.RegionOperationProcedure;
import org.apache.iotdb.confignode.procedure.impl.region.RemoveRegionPeerProcedure;
import org.apache.iotdb.confignode.procedure.state.ReconstructRegionState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconstructRegionProcedure
extends RegionOperationProcedure<ReconstructRegionState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReconstructRegionProcedure.class);
    private TDataNodeLocation targetDataNode;
    private TDataNodeLocation coordinator;

    public ReconstructRegionProcedure() {
    }

    public ReconstructRegionProcedure(TConsensusGroupId regionId, TDataNodeLocation targetDataNode, TDataNodeLocation coordinator) {
        super(regionId);
        this.targetDataNode = targetDataNode;
        this.coordinator = coordinator;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, ReconstructRegionState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        try {
            switch (state) {
                case RECONSTRUCT_REGION_PREPARE: {
                    LOGGER.info("[pid{}][ReconstructRegion] started, region {} on DataNode {}({}) will be reconstructed.", new Object[]{this.getProcId(), this.regionId.getId(), this.targetDataNode.getDataNodeId(), this.targetDataNode.getInternalEndPoint()});
                    this.setNextState(ReconstructRegionState.REMOVE_REGION_PEER);
                    break;
                }
                case REMOVE_REGION_PEER: {
                    this.addChildProcedure(new RemoveRegionPeerProcedure(this.regionId, this.coordinator, this.targetDataNode));
                    this.setNextState(ReconstructRegionState.CHECK_REMOVE_REGION_PEER);
                    break;
                }
                case CHECK_REMOVE_REGION_PEER: {
                    if (env.getConfigManager().getPartitionManager().isDataNodeContainsRegion(this.targetDataNode.getDataNodeId(), this.regionId)) {
                        LOGGER.warn("[pid{}][ReconstructRegion] sub-procedure RemoveRegionPeerProcedure failed, ReconstructRegionProcedure will not continue", (Object)this.getProcId());
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    this.setNextState(ReconstructRegionState.ADD_REGION_PEER);
                    break;
                }
                case ADD_REGION_PEER: {
                    this.addChildProcedure(new AddRegionPeerProcedure(this.regionId, this.coordinator, this.targetDataNode));
                    this.setNextState(ReconstructRegionState.CHECK_ADD_REGION_PEER);
                    break;
                }
                case CHECK_ADD_REGION_PEER: {
                    if (!env.getConfigManager().getPartitionManager().isDataNodeContainsRegion(this.targetDataNode.getDataNodeId(), this.regionId)) {
                        LOGGER.warn("[pid{}][ReconstructRegion] failed, but the region {} has been removed from DataNode {}. Use 'extend region' to fix this.", new Object[]{this.getProcId(), this.regionId.getId(), this.targetDataNode.getDataNodeId()});
                    } else {
                        LOGGER.info("[pid{}][ReconstructRegion] success, region {} has been reconstructed on DataNode {}. Procedure took {} (started at {})", new Object[]{this.getProcId(), this.regionId.getId(), this.targetDataNode.getDataNodeId(), CommonDateTimeUtils.convertMillisecondToDurationStr((long)(System.currentTimeMillis() - this.getSubmittedTime())), DateTimeUtils.convertLongToDate((long)this.getSubmittedTime(), (String)"ms")});
                    }
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new ProcedureException("Unsupported state: " + state.name());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[pid{}][ReconstructRegion] state {} fail", new Object[]{this.getProcId(), state, e});
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        LOGGER.info("[pid{}][ReconstructRegion] state {} complete", (Object)this.getProcId(), (Object)state);
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv configNodeProcedureEnv, ReconstructRegionState reconstructRegionState) throws IOException, InterruptedException, ProcedureException {
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.RECONSTRUCT_REGION_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ThriftCommonsSerDeUtils.serializeTConsensusGroupId((TConsensusGroupId)this.regionId, (DataOutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.targetDataNode, (DataOutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.coordinator, (DataOutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        try {
            this.regionId = ThriftCommonsSerDeUtils.deserializeTConsensusGroupId((ByteBuffer)byteBuffer);
            this.targetDataNode = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)byteBuffer);
            this.coordinator = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)byteBuffer);
        }
        catch (ThriftSerDeException e) {
            LOGGER.warn("Error in deserialize {} (procID {}). This procedure will be ignored. It may belong to old version and cannot be used now.", new Object[]{this.getClass(), this.getProcId(), e});
            throw e;
        }
    }

    @Override
    protected ReconstructRegionState getState(int stateId) {
        return ReconstructRegionState.values()[stateId];
    }

    @Override
    protected int getStateId(ReconstructRegionState reconstructRegionState) {
        return reconstructRegionState.ordinal();
    }

    @Override
    protected ReconstructRegionState getInitialState() {
        return ReconstructRegionState.RECONSTRUCT_REGION_PREPARE;
    }

    @Override
    public String toString() {
        return super.toString() + ", targetDataNode=" + this.targetDataNode.getDataNodeId() + ", coordinator=" + this.coordinator.getDataNodeId();
    }
}

