/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.NodeAttributes;

public class VariableAttributes
extends NodeAttributes
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=355");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=357");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=356");
    private final Variant value;
    private final NodeId dataType;
    private final Integer valueRank;
    private final UInteger[] arrayDimensions;
    private final UByte accessLevel;
    private final UByte userAccessLevel;
    private final Double minimumSamplingInterval;
    private final Boolean historizing;

    public VariableAttributes(UInteger specifiedAttributes, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, Variant value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, Boolean historizing) {
        super(specifiedAttributes, displayName, description, writeMask, userWriteMask);
        this.value = value;
        this.dataType = dataType;
        this.valueRank = valueRank;
        this.arrayDimensions = arrayDimensions;
        this.accessLevel = accessLevel;
        this.userAccessLevel = userAccessLevel;
        this.minimumSamplingInterval = minimumSamplingInterval;
        this.historizing = historizing;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public Variant getValue() {
        return this.value;
    }

    public NodeId getDataType() {
        return this.dataType;
    }

    public Integer getValueRank() {
        return this.valueRank;
    }

    public UInteger[] getArrayDimensions() {
        return this.arrayDimensions;
    }

    public UByte getAccessLevel() {
        return this.accessLevel;
    }

    public UByte getUserAccessLevel() {
        return this.userAccessLevel;
    }

    public Double getMinimumSamplingInterval() {
        return this.minimumSamplingInterval;
    }

    public Boolean getHistorizing() {
        return this.historizing;
    }

    protected VariableAttributes(VariableAttributesBuilder<?, ?> b) {
        super((NodeAttributes.NodeAttributesBuilder<?, ?>)b);
        this.value = ((VariableAttributesBuilder)b).value;
        this.dataType = ((VariableAttributesBuilder)b).dataType;
        this.valueRank = ((VariableAttributesBuilder)b).valueRank;
        this.arrayDimensions = ((VariableAttributesBuilder)b).arrayDimensions;
        this.accessLevel = ((VariableAttributesBuilder)b).accessLevel;
        this.userAccessLevel = ((VariableAttributesBuilder)b).userAccessLevel;
        this.minimumSamplingInterval = ((VariableAttributesBuilder)b).minimumSamplingInterval;
        this.historizing = ((VariableAttributesBuilder)b).historizing;
    }

    public static VariableAttributesBuilder<?, ?> builder() {
        return new VariableAttributesBuilderImpl();
    }

    public VariableAttributesBuilder<?, ?> toBuilder() {
        return new VariableAttributesBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VariableAttributes)) {
            return false;
        }
        VariableAttributes other = (VariableAttributes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$valueRank = this.getValueRank();
        Integer other$valueRank = other.getValueRank();
        if (this$valueRank == null ? other$valueRank != null : !((Object)this$valueRank).equals(other$valueRank)) {
            return false;
        }
        Double this$minimumSamplingInterval = this.getMinimumSamplingInterval();
        Double other$minimumSamplingInterval = other.getMinimumSamplingInterval();
        if (this$minimumSamplingInterval == null ? other$minimumSamplingInterval != null : !((Object)this$minimumSamplingInterval).equals(other$minimumSamplingInterval)) {
            return false;
        }
        Boolean this$historizing = this.getHistorizing();
        Boolean other$historizing = other.getHistorizing();
        if (this$historizing == null ? other$historizing != null : !((Object)this$historizing).equals(other$historizing)) {
            return false;
        }
        Variant this$value = this.getValue();
        Variant other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        NodeId this$dataType = this.getDataType();
        NodeId other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !((Object)this$dataType).equals(other$dataType)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getArrayDimensions(), other.getArrayDimensions())) {
            return false;
        }
        UByte this$accessLevel = this.getAccessLevel();
        UByte other$accessLevel = other.getAccessLevel();
        if (this$accessLevel == null ? other$accessLevel != null : !((Object)this$accessLevel).equals(other$accessLevel)) {
            return false;
        }
        UByte this$userAccessLevel = this.getUserAccessLevel();
        UByte other$userAccessLevel = other.getUserAccessLevel();
        return !(this$userAccessLevel == null ? other$userAccessLevel != null : !((Object)this$userAccessLevel).equals(other$userAccessLevel));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VariableAttributes;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $valueRank = this.getValueRank();
        result = result * 59 + ($valueRank == null ? 43 : ((Object)$valueRank).hashCode());
        Double $minimumSamplingInterval = this.getMinimumSamplingInterval();
        result = result * 59 + ($minimumSamplingInterval == null ? 43 : ((Object)$minimumSamplingInterval).hashCode());
        Boolean $historizing = this.getHistorizing();
        result = result * 59 + ($historizing == null ? 43 : ((Object)$historizing).hashCode());
        Variant $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        NodeId $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)$dataType).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getArrayDimensions());
        UByte $accessLevel = this.getAccessLevel();
        result = result * 59 + ($accessLevel == null ? 43 : ((Object)$accessLevel).hashCode());
        UByte $userAccessLevel = this.getUserAccessLevel();
        result = result * 59 + ($userAccessLevel == null ? 43 : ((Object)$userAccessLevel).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "VariableAttributes(value=" + this.getValue() + ", dataType=" + this.getDataType() + ", valueRank=" + this.getValueRank() + ", arrayDimensions=" + Arrays.deepToString(this.getArrayDimensions()) + ", accessLevel=" + this.getAccessLevel() + ", userAccessLevel=" + this.getUserAccessLevel() + ", minimumSamplingInterval=" + this.getMinimumSamplingInterval() + ", historizing=" + this.getHistorizing() + ")";
    }

    private static final class VariableAttributesBuilderImpl
    extends VariableAttributesBuilder<VariableAttributes, VariableAttributesBuilderImpl> {
        private VariableAttributesBuilderImpl() {
        }

        @Override
        protected VariableAttributesBuilderImpl self() {
            return this;
        }

        @Override
        public VariableAttributes build() {
            return new VariableAttributes(this);
        }
    }

    public static abstract class VariableAttributesBuilder<C extends VariableAttributes, B extends VariableAttributesBuilder<C, B>>
    extends NodeAttributes.NodeAttributesBuilder<C, B> {
        private Variant value;
        private NodeId dataType;
        private Integer valueRank;
        private UInteger[] arrayDimensions;
        private UByte accessLevel;
        private UByte userAccessLevel;
        private Double minimumSamplingInterval;
        private Boolean historizing;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            VariableAttributesBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(VariableAttributes instance, VariableAttributesBuilder<?, ?> b) {
            b.value(instance.value);
            b.dataType(instance.dataType);
            b.valueRank(instance.valueRank);
            b.arrayDimensions(instance.arrayDimensions);
            b.accessLevel(instance.accessLevel);
            b.userAccessLevel(instance.userAccessLevel);
            b.minimumSamplingInterval(instance.minimumSamplingInterval);
            b.historizing(instance.historizing);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B value(Variant value) {
            this.value = value;
            return (B)this.self();
        }

        public B dataType(NodeId dataType) {
            this.dataType = dataType;
            return (B)this.self();
        }

        public B valueRank(Integer valueRank) {
            this.valueRank = valueRank;
            return (B)this.self();
        }

        public B arrayDimensions(UInteger[] arrayDimensions) {
            this.arrayDimensions = arrayDimensions;
            return (B)this.self();
        }

        public B accessLevel(UByte accessLevel) {
            this.accessLevel = accessLevel;
            return (B)this.self();
        }

        public B userAccessLevel(UByte userAccessLevel) {
            this.userAccessLevel = userAccessLevel;
            return (B)this.self();
        }

        public B minimumSamplingInterval(Double minimumSamplingInterval) {
            this.minimumSamplingInterval = minimumSamplingInterval;
            return (B)this.self();
        }

        public B historizing(Boolean historizing) {
            this.historizing = historizing;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "VariableAttributes.VariableAttributesBuilder(super=" + super.toString() + ", value=" + this.value + ", dataType=" + this.dataType + ", valueRank=" + this.valueRank + ", arrayDimensions=" + Arrays.deepToString(this.arrayDimensions) + ", accessLevel=" + this.accessLevel + ", userAccessLevel=" + this.userAccessLevel + ", minimumSamplingInterval=" + this.minimumSamplingInterval + ", historizing=" + this.historizing + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<VariableAttributes> {
        @Override
        public Class<VariableAttributes> getType() {
            return VariableAttributes.class;
        }

        @Override
        public VariableAttributes decode(SerializationContext context, UaDecoder decoder) {
            UInteger specifiedAttributes = decoder.readUInt32("SpecifiedAttributes");
            LocalizedText displayName = decoder.readLocalizedText("DisplayName");
            LocalizedText description = decoder.readLocalizedText("Description");
            UInteger writeMask = decoder.readUInt32("WriteMask");
            UInteger userWriteMask = decoder.readUInt32("UserWriteMask");
            Variant value = decoder.readVariant("Value");
            NodeId dataType = decoder.readNodeId("DataType");
            Integer valueRank = decoder.readInt32("ValueRank");
            UInteger[] arrayDimensions = decoder.readUInt32Array("ArrayDimensions");
            UByte accessLevel = decoder.readByte("AccessLevel");
            UByte userAccessLevel = decoder.readByte("UserAccessLevel");
            Double minimumSamplingInterval = decoder.readDouble("MinimumSamplingInterval");
            Boolean historizing = decoder.readBoolean("Historizing");
            return new VariableAttributes(specifiedAttributes, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, VariableAttributes value) {
            encoder.writeUInt32("SpecifiedAttributes", value.getSpecifiedAttributes());
            encoder.writeLocalizedText("DisplayName", value.getDisplayName());
            encoder.writeLocalizedText("Description", value.getDescription());
            encoder.writeUInt32("WriteMask", value.getWriteMask());
            encoder.writeUInt32("UserWriteMask", value.getUserWriteMask());
            encoder.writeVariant("Value", value.getValue());
            encoder.writeNodeId("DataType", value.getDataType());
            encoder.writeInt32("ValueRank", value.getValueRank());
            encoder.writeUInt32Array("ArrayDimensions", value.getArrayDimensions());
            encoder.writeByte("AccessLevel", value.getAccessLevel());
            encoder.writeByte("UserAccessLevel", value.getUserAccessLevel());
            encoder.writeDouble("MinimumSamplingInterval", value.getMinimumSamplingInterval());
            encoder.writeBoolean("Historizing", value.getHistorizing());
        }
    }
}

