/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.config;

import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.ReloadLevel;
import org.apache.iotdb.metrics.utils.InternalReporterType;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.ReporterType;

public class MetricConfigDescriptor {
    private static final MetricConfig metricConfig = new MetricConfig();

    private MetricConfigDescriptor() {
    }

    public void loadProps(Properties properties, boolean isConfigNode) {
        MetricConfig loadConfig = this.generateFromProperties(properties, isConfigNode);
        metricConfig.copy(loadConfig);
    }

    public ReloadLevel loadHotProps(Properties properties, boolean isConfigNode) {
        MetricConfig newMetricConfig = this.generateFromProperties(properties, isConfigNode);
        ReloadLevel reloadLevel = ReloadLevel.NOTHING;
        if (!metricConfig.equals(newMetricConfig)) {
            reloadLevel = !metricConfig.getMetricLevel().equals((Object)newMetricConfig.getMetricLevel()) || !metricConfig.getAsyncCollectPeriodInSecond().equals(newMetricConfig.getAsyncCollectPeriodInSecond()) ? ReloadLevel.RESTART_METRIC : (!metricConfig.getInternalReportType().equals((Object)newMetricConfig.getInternalReportType()) ? ReloadLevel.RESTART_INTERNAL_REPORTER : ReloadLevel.RESTART_REPORTER);
            metricConfig.copy(newMetricConfig);
        }
        return reloadLevel;
    }

    private MetricConfig generateFromProperties(Properties properties, boolean isConfigNode) {
        MetricConfig loadConfig = new MetricConfig();
        String reporterList = this.getProperty("metric_reporter_list", String.join((CharSequence)",", loadConfig.getMetricReporterList().stream().map(ReporterType::toString).collect(Collectors.toSet())), properties, isConfigNode);
        loadConfig.setMetricReporterList(reporterList);
        loadConfig.setMetricLevel(MetricLevel.valueOf(this.getProperty("metric_level", String.valueOf((Object)loadConfig.getMetricLevel()), properties, isConfigNode)));
        loadConfig.setAsyncCollectPeriodInSecond(Integer.parseInt(this.getProperty("metric_async_collect_period", String.valueOf(loadConfig.getAsyncCollectPeriodInSecond()), properties, isConfigNode)));
        loadConfig.setPrometheusReporterPort(Integer.parseInt(this.getProperty("metric_prometheus_reporter_port", String.valueOf(loadConfig.getPrometheusReporterPort()), properties, isConfigNode)));
        MetricConfig.IoTDBReporterConfig reporterConfig = loadConfig.getIoTDBReporterConfig();
        reporterConfig.setHost(this.getProperty("metric_iotdb_reporter_host", reporterConfig.getHost(), properties, isConfigNode));
        reporterConfig.setPort(Integer.valueOf(this.getProperty("metric_iotdb_reporter_port", String.valueOf(reporterConfig.getPort()), properties, isConfigNode)));
        reporterConfig.setUsername(this.getProperty("metric_iotdb_reporter_username", reporterConfig.getUsername(), properties, isConfigNode));
        reporterConfig.setPassword(this.getProperty("metric_iotdb_reporter_password", reporterConfig.getPassword(), properties, isConfigNode));
        reporterConfig.setMaxConnectionNumber(Integer.valueOf(this.getProperty("metric_iotdb_reporter_max_connection_number", String.valueOf(reporterConfig.getMaxConnectionNumber()), properties, isConfigNode)));
        reporterConfig.setLocation(this.getProperty("metric_iotdb_reporter_location", reporterConfig.getLocation(), properties, isConfigNode));
        reporterConfig.setPushPeriodInSecond(Integer.valueOf(this.getProperty("metric_iotdb_reporter_push_period", String.valueOf(reporterConfig.getPushPeriodInSecond()), properties, isConfigNode)));
        if (!isConfigNode) {
            loadConfig.setInternalReportType(InternalReporterType.valueOf(properties.getProperty("dn_metric_internal_reporter_type", loadConfig.getInternalReportType().toString())));
        }
        return loadConfig;
    }

    private String getProperty(String target, String defaultValue, Properties properties, boolean isConfigNode) {
        return Optional.ofNullable(properties.getProperty((isConfigNode ? "cn_" : "dn_") + target, defaultValue)).map(String::trim).orElse(defaultValue);
    }

    public static MetricConfigDescriptor getInstance() {
        return MetricConfigDescriptorHolder.INSTANCE;
    }

    public MetricConfig getMetricConfig() {
        return metricConfig;
    }

    private static class MetricConfigDescriptorHolder {
        private static final MetricConfigDescriptor INSTANCE = new MetricConfigDescriptor();

        private MetricConfigDescriptorHolder() {
        }
    }
}

