/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.dataregion.realtime.assigner;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.tsfile.utils.Pair;

public class PipeTimePartitionProgressIndexKeeper {
    private final Map<String, Map<Long, Pair<ProgressIndex, Boolean>>> progressIndexKeeper = new ConcurrentHashMap<String, Map<Long, Pair<ProgressIndex, Boolean>>>();

    public synchronized void updateProgressIndex(String dataRegionId, long timePartitionId, ProgressIndex progressIndex) {
        this.progressIndexKeeper.computeIfAbsent(dataRegionId, k -> new ConcurrentHashMap()).compute(timePartitionId, (k, v) -> {
            if (v == null) {
                return new Pair((Object)progressIndex, (Object)true);
            }
            return new Pair((Object)((ProgressIndex)v.getLeft()).updateToMinimumEqualOrIsAfterProgressIndex(progressIndex), (Object)true);
        });
    }

    public synchronized void eliminateProgressIndex(String dataRegionId, long timePartitionId, ProgressIndex progressIndex) {
        this.progressIndexKeeper.computeIfAbsent(dataRegionId, k -> new ConcurrentHashMap()).compute(timePartitionId, (k, v) -> {
            if (v == null) {
                return null;
            }
            if (((Boolean)v.getRight()).booleanValue() && !((ProgressIndex)v.getLeft()).isAfter(progressIndex)) {
                return new Pair((Object)((ProgressIndex)v.getLeft()), (Object)false);
            }
            return v;
        });
    }

    public synchronized boolean isProgressIndexAfterOrEquals(String dataRegionId, long timePartitionId, ProgressIndex progressIndex) {
        return this.progressIndexKeeper.computeIfAbsent(dataRegionId, k -> new ConcurrentHashMap()).entrySet().stream().filter(entry -> (Long)entry.getKey() != timePartitionId).map(Map.Entry::getValue).filter(pair -> (Boolean)pair.right).map(Pair::getLeft).filter(Objects::nonNull).anyMatch(index -> !index.isAfter(progressIndex));
    }

    public static PipeTimePartitionProgressIndexKeeper getInstance() {
        return PipeTimePartitionProgressIndexKeeperHolder.INSTANCE;
    }

    private PipeTimePartitionProgressIndexKeeper() {
    }

    private static class PipeTimePartitionProgressIndexKeeperHolder {
        private static final PipeTimePartitionProgressIndexKeeper INSTANCE = new PipeTimePartitionProgressIndexKeeper();

        private PipeTimePartitionProgressIndexKeeperHolder() {
        }
    }
}

