/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.resources;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.FastThreadLocalThread;
import java.time.Duration;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.NonBlocking;
import reactor.netty.FutureMono;
import reactor.netty.resources.DefaultLoop;
import reactor.netty.resources.DefaultLoopNativeDetector;
import reactor.netty.resources.LoopResources;

final class DefaultLoopResources
extends AtomicLong
implements LoopResources {
    final String prefix;
    final boolean daemon;
    final int selectCount;
    final int workerCount;
    final AtomicReference<EventLoopGroup> serverLoops;
    final AtomicReference<EventLoopGroup> clientLoops;
    final AtomicReference<EventLoopGroup> serverSelectLoops;
    final AtomicReference<EventLoopGroup> cacheNativeClientLoops;
    final AtomicReference<EventLoopGroup> cacheNativeServerLoops;
    final AtomicReference<EventLoopGroup> cacheNativeSelectLoops;
    final AtomicBoolean running = new AtomicBoolean(true);

    DefaultLoopResources(String prefix, int workerCount, boolean daemon) {
        this(prefix, -1, workerCount, daemon);
    }

    DefaultLoopResources(String prefix, int selectCount, int workerCount, boolean daemon) {
        this.daemon = daemon;
        this.workerCount = workerCount;
        this.prefix = prefix;
        this.serverLoops = new AtomicReference();
        this.clientLoops = new AtomicReference();
        this.cacheNativeClientLoops = new AtomicReference();
        this.cacheNativeServerLoops = new AtomicReference();
        if (selectCount == -1) {
            this.selectCount = workerCount;
            this.serverSelectLoops = this.serverLoops;
            this.cacheNativeSelectLoops = this.cacheNativeServerLoops;
        } else {
            this.selectCount = selectCount;
            this.serverSelectLoops = new AtomicReference();
            this.cacheNativeSelectLoops = new AtomicReference();
        }
    }

    @Override
    public Mono<Void> disposeLater(Duration quietPeriod, Duration timeout) {
        return Mono.defer(() -> {
            long quietPeriodMillis = quietPeriod.toMillis();
            long timeoutMillis = timeout.toMillis();
            EventLoopGroup serverLoopsGroup = this.serverLoops.get();
            EventLoopGroup clientLoopsGroup = this.clientLoops.get();
            EventLoopGroup serverSelectLoopsGroup = this.serverSelectLoops.get();
            EventLoopGroup cacheNativeClientGroup = this.cacheNativeClientLoops.get();
            EventLoopGroup cacheNativeSelectGroup = this.cacheNativeSelectLoops.get();
            EventLoopGroup cacheNativeServerGroup = this.cacheNativeServerLoops.get();
            Mono<Void> clMono = Mono.empty();
            Mono<Void> sslMono = Mono.empty();
            Mono<Void> slMono = Mono.empty();
            Mono<Void> cnclMono = Mono.empty();
            Mono<Void> cnslMono = Mono.empty();
            Mono<Void> cnsrvlMono = Mono.empty();
            if (this.running.compareAndSet(true, false)) {
                if (clientLoopsGroup != null) {
                    clMono = FutureMono.from(clientLoopsGroup.shutdownGracefully(quietPeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS));
                }
                if (serverSelectLoopsGroup != null) {
                    sslMono = FutureMono.from(serverSelectLoopsGroup.shutdownGracefully(quietPeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS));
                }
                if (serverLoopsGroup != null) {
                    slMono = FutureMono.from(serverLoopsGroup.shutdownGracefully(quietPeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS));
                }
                if (cacheNativeClientGroup != null) {
                    cnclMono = FutureMono.from(cacheNativeClientGroup.shutdownGracefully(quietPeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS));
                }
                if (cacheNativeSelectGroup != null) {
                    cnslMono = FutureMono.from(cacheNativeSelectGroup.shutdownGracefully(quietPeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS));
                }
                if (cacheNativeServerGroup != null) {
                    cnsrvlMono = FutureMono.from(cacheNativeServerGroup.shutdownGracefully(quietPeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS));
                }
            }
            return Mono.when((Publisher[])new Publisher[]{clMono, sslMono, slMono, cnclMono, cnslMono, cnsrvlMono});
        });
    }

    public boolean isDisposed() {
        return !this.running.get();
    }

    @Override
    public EventLoopGroup onClient(boolean useNative) {
        if (useNative && LoopResources.hasNativeSupport()) {
            return this.cacheNativeClientLoops();
        }
        return this.cacheNioClientLoops();
    }

    @Override
    public EventLoopGroup onServer(boolean useNative) {
        if (useNative && LoopResources.hasNativeSupport()) {
            return this.cacheNativeServerLoops();
        }
        return this.cacheNioServerLoops();
    }

    @Override
    public EventLoopGroup onServerSelect(boolean useNative) {
        if (useNative && LoopResources.hasNativeSupport()) {
            return this.cacheNativeSelectLoops();
        }
        return this.cacheNioSelectLoops();
    }

    @Override
    public String toString() {
        return "DefaultLoopResources {prefix=" + this.prefix + ", daemon=" + this.daemon + ", selectCount=" + this.selectCount + ", workerCount=" + this.workerCount + '}';
    }

    EventLoopGroup cacheNioClientLoops() {
        EventLoopGroup eventLoopGroup = this.clientLoops.get();
        if (null == eventLoopGroup) {
            EventLoopGroup newEventLoopGroup = LoopResources.colocate(this.cacheNioServerLoops());
            if (!this.clientLoops.compareAndSet(null, newEventLoopGroup)) {
                // empty if block
            }
            eventLoopGroup = this.cacheNioClientLoops();
        }
        return eventLoopGroup;
    }

    EventLoopGroup cacheNioSelectLoops() {
        if (this.serverSelectLoops == this.serverLoops) {
            return this.cacheNioServerLoops();
        }
        EventLoopGroup eventLoopGroup = this.serverSelectLoops.get();
        if (null == eventLoopGroup) {
            NioEventLoopGroup newEventLoopGroup = new NioEventLoopGroup(this.selectCount, DefaultLoopResources.threadFactory(this, "select-nio"));
            if (!this.serverSelectLoops.compareAndSet(null, (EventLoopGroup)newEventLoopGroup)) {
                newEventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
            }
            eventLoopGroup = this.cacheNioSelectLoops();
        }
        return eventLoopGroup;
    }

    EventLoopGroup cacheNioServerLoops() {
        EventLoopGroup eventLoopGroup = this.serverLoops.get();
        if (null == eventLoopGroup) {
            NioEventLoopGroup newEventLoopGroup = new NioEventLoopGroup(this.workerCount, DefaultLoopResources.threadFactory(this, "nio"));
            if (!this.serverLoops.compareAndSet(null, (EventLoopGroup)newEventLoopGroup)) {
                newEventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
            }
            eventLoopGroup = this.cacheNioServerLoops();
        }
        return eventLoopGroup;
    }

    EventLoopGroup cacheNativeClientLoops() {
        EventLoopGroup eventLoopGroup = this.cacheNativeClientLoops.get();
        if (null == eventLoopGroup) {
            EventLoopGroup newEventLoopGroup = LoopResources.colocate(this.cacheNativeServerLoops());
            if (!this.cacheNativeClientLoops.compareAndSet(null, newEventLoopGroup)) {
                // empty if block
            }
            eventLoopGroup = this.cacheNativeClientLoops();
        }
        return eventLoopGroup;
    }

    EventLoopGroup cacheNativeSelectLoops() {
        if (this.cacheNativeSelectLoops == this.cacheNativeServerLoops) {
            return this.cacheNativeServerLoops();
        }
        EventLoopGroup eventLoopGroup = this.cacheNativeSelectLoops.get();
        if (null == eventLoopGroup) {
            DefaultLoop defaultLoop = DefaultLoopNativeDetector.INSTANCE;
            EventLoopGroup newEventLoopGroup = defaultLoop.newEventLoopGroup(this.selectCount, DefaultLoopResources.threadFactory(this, "select-" + defaultLoop.getName()));
            if (!this.cacheNativeSelectLoops.compareAndSet(null, newEventLoopGroup)) {
                newEventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
            }
            eventLoopGroup = this.cacheNativeSelectLoops();
        }
        return eventLoopGroup;
    }

    EventLoopGroup cacheNativeServerLoops() {
        EventLoopGroup eventLoopGroup = this.cacheNativeServerLoops.get();
        if (null == eventLoopGroup) {
            DefaultLoop defaultLoop = DefaultLoopNativeDetector.INSTANCE;
            EventLoopGroup newEventLoopGroup = defaultLoop.newEventLoopGroup(this.workerCount, DefaultLoopResources.threadFactory(this, defaultLoop.getName()));
            if (!this.cacheNativeServerLoops.compareAndSet(null, newEventLoopGroup)) {
                newEventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
            }
            eventLoopGroup = this.cacheNativeServerLoops();
        }
        return eventLoopGroup;
    }

    static ThreadFactory threadFactory(DefaultLoopResources parent, String prefix) {
        return new EventLoopFactory(parent.daemon, parent.prefix + "-" + prefix, parent);
    }

    static final class EventLoopFactory
    implements ThreadFactory {
        final boolean daemon;
        final AtomicLong counter;
        final String prefix;

        EventLoopFactory(boolean daemon, String prefix, AtomicLong counter) {
            this.daemon = daemon;
            this.counter = counter;
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            EventLoop t = new EventLoop(r);
            ((Thread)((Object)t)).setDaemon(this.daemon);
            ((Thread)((Object)t)).setName(this.prefix + "-" + this.counter.incrementAndGet());
            return t;
        }
    }

    static final class EventLoop
    extends FastThreadLocalThread
    implements NonBlocking {
        EventLoop(Runnable target) {
            super(target);
        }
    }
}

